/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.xebialabs.deployit.ServerConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerConfigFile {
    private final File configFile;
    private static final Logger logger = LoggerFactory.getLogger(ServerConfigFile.class);

    public ServerConfigFile(File file) {
        this.configFile = file;
    }

    public boolean exists() {
        return this.configFile.exists();
    }

    public String getName() {
        return this.configFile.getName();
    }

    public void readIntoConfiguration(ServerConfiguration serverConfiguration) {
        serverConfiguration.load(ServerConfigFile.readConfigurationFile(this.configFile));
    }

    public ServerConfiguration loadConfig() {
        if (this.configFile.exists()) {
            ServerConfiguration serverConfiguration = ServerConfigFile.readConfiguration(this.configFile);
            if (!serverConfiguration.isValid()) {
                throw new Error("Configuration " + this.configFile + " is not valid please run with -setup option.");
            }
            if (serverConfiguration.isDirty()) {
                logger.info("Saving (dirty) configuration");
                this.writeConfiguration(serverConfiguration);
            }
            return serverConfiguration;
        }
        throw new Error("Configuration " + this.configFile + " does not exist, please run with -setup option before starting the server or command line interface.");
    }

    static ServerConfiguration readConfiguration(File configFile) {
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        serverConfiguration.setFile(configFile);
        serverConfiguration.load(ServerConfigFile.readConfigurationFile(configFile));
        return serverConfiguration;
    }

    static Properties readConfigurationFile(File configFile) {
        Properties properties = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = (FileInputStream)Files.newInputStreamSupplier((File)configFile).getInput();
            properties.load(inStream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(inStream);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)inStream);
        return properties;
    }

    public void writeConfiguration(ServerConfiguration serverConfiguration) {
        Properties properties = new Properties();
        serverConfiguration.save(properties);
        FileOutputStream output = null;
        try {
            output = (FileOutputStream)Files.newOutputStreamSupplier((File)this.configFile).getOutput();
            properties.store(output, "Deployit configuration file.");
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(output);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)output);
    }

    public String toString() {
        return this.configFile.getAbsolutePath();
    }
}

