/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.spi;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.util.ConsoleOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.OverthereProcessOutputHandlerWrapper;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOverthereConnection
implements OverthereConnection {
    protected final String protocol;
    protected final ConnectionOptions options;
    protected final AddressPortMapper mapper;
    protected final OperatingSystemFamily os;
    protected final int connectionTimeoutMillis;
    protected final String temporaryDirectoryPath;
    protected final boolean deleteTemporaryDirectoryOnDisconnect;
    protected final int temporaryFileCreationRetries;
    protected final boolean canStartProcess;
    protected OverthereFile connectionTemporaryDirectory;
    protected OverthereFile workingDirectory;
    protected Random random = new Random();
    private static Logger logger = LoggerFactory.getLogger(BaseOverthereConnection.class);

    protected BaseOverthereConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper, boolean canStartProcess) {
        this.protocol = (String)Preconditions.checkNotNull((Object)protocol, (Object)"Cannot create OverthereConnection with null protocol");
        this.options = (ConnectionOptions)Preconditions.checkNotNull((Object)options, (Object)"Cannot create OverthereConnection with null options");
        this.mapper = (AddressPortMapper)Preconditions.checkNotNull((Object)mapper, (Object)"Cannot create OverthereConnection with null addres-port mapper");
        this.os = options.getEnum("os", OperatingSystemFamily.class);
        this.connectionTimeoutMillis = options.getInteger("connectionTimeoutMillis", 120000);
        this.temporaryDirectoryPath = options.get("tmp", this.os.getDefaultTemporaryDirectoryPath());
        this.deleteTemporaryDirectoryOnDisconnect = options.getBoolean("tmpDeleteOnDisconnect", true);
        this.temporaryFileCreationRetries = options.getInteger("tmpFileCreationRetries", 100);
        this.canStartProcess = canStartProcess;
    }

    @Override
    public OperatingSystemFamily getHostOperatingSystem() {
        return this.os;
    }

    @Override
    public final void close() {
        if (this.deleteTemporaryDirectoryOnDisconnect) {
            this.deleteConnectionTemporaryDirectory();
        }
        this.doClose();
        Closeables.closeQuietly((Closeable)this.mapper);
        logger.info("Disconnected from {}", (Object)this);
    }

    protected abstract void doClose();

    @Override
    public final OverthereFile getTempFile(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            name = "tmp";
        }
        for (int i = 0; i <= this.temporaryFileCreationRetries; ++i) {
            String infix = Long.toString(Math.abs(this.random.nextLong()));
            OverthereFile f = this.getFileForTempFile(this.getConnectionTemporaryDirectory(), infix);
            if (f.exists()) continue;
            logger.trace("Creating holder directory {} for temporary file with name {}", (Object)f, (Object)name);
            f.mkdir();
            OverthereFile t = f.getFile(name);
            logger.debug("Created temporary file {}", (Object)t);
            return t;
        }
        throw new RuntimeIOException("Cannot generate a unique temporary file name on " + this);
    }

    @Override
    public final OverthereFile getTempFile(String prefix, String suffix) throws RuntimeIOException {
        if (prefix == null) {
            throw new NullPointerException("prefix is null");
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        return this.getTempFile(prefix + suffix);
    }

    private OverthereFile getConnectionTemporaryDirectory() throws RuntimeIOException {
        if (this.connectionTemporaryDirectory == null) {
            this.connectionTemporaryDirectory = this.createConnectionTemporaryDirectory();
        }
        return this.connectionTemporaryDirectory;
    }

    private OverthereFile createConnectionTemporaryDirectory() {
        OverthereFile temporaryDirectory = this.getFile(this.temporaryDirectoryPath);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        String prefix = "overthere-" + dateFormat.format(new Date());
        String infix = "";
        String suffix = ".tmp";
        for (int i = 0; i < this.temporaryFileCreationRetries; ++i) {
            OverthereFile tempDir = this.getFileForTempFile(temporaryDirectory, prefix + infix + suffix);
            if (!tempDir.exists()) {
                tempDir.mkdir();
                logger.info("Created connection temporary directory {}", (Object)tempDir);
                return tempDir;
            }
            infix = "-" + Long.toString(Math.abs(this.random.nextLong()));
        }
        throw new RuntimeIOException("Cannot create connection temporary directory on " + this);
    }

    private void deleteConnectionTemporaryDirectory() {
        if (this.connectionTemporaryDirectory != null) {
            try {
                logger.info("Deleting connection temporary directory {}", (Object)this.connectionTemporaryDirectory);
                this.connectionTemporaryDirectory.deleteRecursively();
            }
            catch (RuntimeException exc) {
                logger.warn("Got exception while deleting connection temporary directory {}. Ignoring it.", (Object)this.connectionTemporaryDirectory, (Object)exc);
            }
        }
    }

    protected abstract OverthereFile getFileForTempFile(OverthereFile var1, String var2);

    @Override
    public OverthereFile getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ConnectionOptions getOptions() {
        return this.options;
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public final int execute(CmdLine commandLine) {
        return this.execute(ConsoleOverthereExecutionOutputHandler.sysoutHandler(), ConsoleOverthereExecutionOutputHandler.syserrHandler(), commandLine);
    }

    @Override
    public int execute(OverthereExecutionOutputHandler stdoutHandler, OverthereExecutionOutputHandler stderrHandler, CmdLine commandLine) {
        OverthereProcess process = this.startProcess(commandLine);
        Thread stdoutReaderThread = null;
        Thread stderrReaderThread = null;
        CountDownLatch latch = new CountDownLatch(2);
        stdoutReaderThread = this.getThread("stdout", commandLine.toString(), stdoutHandler, process.getStdout(), latch);
        stdoutReaderThread.start();
        stderrReaderThread = this.getThread("stderr", commandLine.toString(), stderrHandler, process.getStderr(), latch);
        stderrReaderThread.start();
        try {
            latch.await();
            int n = process.waitFor();
            this.quietlyJoinThread(stdoutReaderThread);
            this.quietlyJoinThread(stderrReaderThread);
            return n;
        }
        catch (InterruptedException exc) {
            try {
                Thread.currentThread().interrupt();
                logger.info("Execution interrupted, destroying the process.");
                process.destroy();
                throw new RuntimeIOException("Execution interrupted", exc);
            }
            catch (Throwable throwable) {
                this.quietlyJoinThread(stdoutReaderThread);
                this.quietlyJoinThread(stderrReaderThread);
                throw throwable;
            }
        }
    }

    private void quietlyJoinThread(Thread thread) {
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Thread getThread(final String streamName, final String commandLine, final OverthereExecutionOutputHandler outputHandler, final InputStream stream, final CountDownLatch latch) {
        Thread t = new Thread(String.format("%s reader", streamName)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringBuilder lineBuffer = new StringBuilder();
                InputStreamReader stdoutReader = new InputStreamReader(stream);
                latch.countDown();
                try {
                    int cInt = stdoutReader.read();
                    while (cInt > -1) {
                        char c = (char)cInt;
                        outputHandler.handleChar(c);
                        if (c != '\r' && c != '\n') {
                            lineBuffer.append(c);
                        }
                        if (c == '\n') {
                            outputHandler.handleLine(lineBuffer.toString());
                            lineBuffer.setLength(0);
                        }
                        cInt = stdoutReader.read();
                    }
                }
                catch (Exception exc) {
                    logger.error(String.format("An exception occured reading %s while executing [%s] on %s", streamName, commandLine, this), (Throwable)exc);
                }
                finally {
                    Closeables.closeQuietly((Closeable)stdoutReader);
                    if (lineBuffer.length() > 0) {
                        outputHandler.handleLine(lineBuffer.toString());
                    }
                }
            }
        };
        t.setDaemon(true);
        return t;
    }

    @Override
    public final int execute(OverthereProcessOutputHandler handler, CmdLine commandLine) {
        return this.execute(OverthereProcessOutputHandlerWrapper.wrapStdout(handler), OverthereProcessOutputHandlerWrapper.wrapStderr(handler), commandLine);
    }

    @Override
    public OverthereProcess startProcess(CmdLine commandLine) {
        throw new UnsupportedOperationException("Cannot start a process on " + this);
    }

    @Override
    public final boolean canStartProcess() {
        return this.canStartProcess;
    }

    @Override
    public abstract String toString();
}

