/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.xml.PasswordEncryptingXStreamCiConverter;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.io.DerivedArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.xstream.CiXstreamReader;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@XStreamProvider(tagName="configuration-item", readable=ConfigurationItem.class)
public class XStreamCiConverterWithRepository
extends PasswordEncryptingXStreamCiConverter {
    static final ThreadLocal<Map<String, ConfigurationItem>> DESERIALIZATION_CONTEXT = new ThreadLocal<Map<String, ConfigurationItem>>(){

        @Override
        protected Map<String, ConfigurationItem> initialValue() {
            return Maps.newHashMap();
        }
    };
    static final ThreadLocal<List<CiReference>> DESERIALIZATION_REFERENCES = new ThreadLocal<List<CiReference>>(){

        @Override
        protected List<CiReference> initialValue() {
            return Lists.newArrayList();
        }
    };
    static final ThreadLocal<RepositoryService> REPOSITORY = new ThreadLocal();
    private final RepositoryService repository;
    private static final Logger logger = LoggerFactory.getLogger(XStreamCiConverterWithRepository.class);

    @Autowired
    public XStreamCiConverterWithRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConfigurationItemConverter converter = this.createConverter((DataHolder)context);
        ConfigurationItem ci = converter.readCi((CiReader)new CiXstreamReader(reader));
        DESERIALIZATION_REFERENCES.get().addAll(converter.getReferences());
        if (ci instanceof DerivedArtifact && WorkdirHolder.get() != null) {
            logger.trace("Setting DerivedFile on {}", (Object)ci.getId());
            ((DerivedArtifact)ci).setFile((OverthereFile)DerivedArtifactFile.create((DerivedArtifact)((DerivedArtifact)ci)));
        }
        REPOSITORY.set(this.repository);
        if (ci instanceof ValidatedConfigurationItem) {
            DESERIALIZATION_CONTEXT.get().put(ci.getId(), ((ValidatedConfigurationItem)ci).getWrapped());
        } else {
            DESERIALIZATION_CONTEXT.get().put(ci.getId(), ci);
        }
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void postProcess() {
        try {
            for (CiReference reference : DESERIALIZATION_REFERENCES.get()) {
                XStreamCiConverterWithRepository.resolve(reference);
            }
        }
        finally {
            XStreamCiConverterWithRepository.clear();
        }
    }

    private static void resolve(CiReference reference) {
        ArrayList cis = Lists.newArrayList();
        for (String id : reference.getIds()) {
            cis.add(XStreamCiConverterWithRepository.readCi(id));
        }
        reference.set((List)cis);
    }

    private static ConfigurationItem readCi(String id) {
        if (DESERIALIZATION_CONTEXT.get().containsKey(id)) {
            return DESERIALIZATION_CONTEXT.get().get(id);
        }
        return REPOSITORY.get().read(id, WorkdirHolder.get());
    }

    public static void clear() {
        DESERIALIZATION_REFERENCES.remove();
        DESERIALIZATION_CONTEXT.remove();
        REPOSITORY.remove();
    }
}

