/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.id;

import java.security.SecureRandom;
import java.util.Random;

class SeededSecureRandom
extends SecureRandom
implements Runnable {
    private static final int MAX_SEED_TIME = 1000;
    private static volatile Random instance = null;
    private volatile boolean seeded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Random getInstance() {
        if (instance != null) return instance;
        Class<SeededSecureRandom> clazz = SeededSecureRandom.class;
        synchronized (SeededSecureRandom.class) {
            if (instance != null) return instance;
            instance = new SeededSecureRandom();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SeededSecureRandom() {
        Thread thread = new Thread((Runnable)this, "SeededSecureRandom");
        thread.start();
        try {
            thread.join(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!this.seeded) {
            this.setSeed(System.currentTimeMillis());
            this.setSeed(System.nanoTime());
            this.setSeed(new Object().hashCode());
            Runtime runtime = Runtime.getRuntime();
            this.setSeed(runtime.freeMemory());
            this.setSeed(runtime.maxMemory());
            this.setSeed(runtime.totalMemory());
            this.setSeed(System.getProperties().toString().hashCode());
            for (int j = 0; j < 16; ++j) {
                int i = 0;
                long start = System.currentTimeMillis();
                while (start == System.currentTimeMillis()) {
                    ++i;
                }
                this.setSeed(i);
            }
        }
    }

    @Override
    public void run() {
        this.setSeed(this.generateSeed(32));
        this.seeded = true;
    }
}

