/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState2;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.json.StepJsonConverter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public abstract class TaskJsonConverter {
    private final DateTimeAdapter timeAdapter = new DateTimeAdapter();
    private final StepJsonConverter stepConverter;

    public TaskJsonConverter(StepJsonConverter stepConverter) {
        this.stepConverter = stepConverter;
    }

    public String toJson(TaskState task) {
        JsonWriter writer = new JsonWriter();
        writer.object();
        writer.key("id").value(task.getId());
        writer.key("currentStep").value(task.getCurrentStepNr());
        writer.key("totalSteps").value(task.getNrSteps());
        writer.key("state").value(task.getState());
        writer.key("state2").value(task.getState2());
        writer.key("failures").value(task.getFailureCount());
        writer.key("description").value(task.getDescription());
        if (task.getStartDate() != null) {
            writer.key("startDate").value(this.timeAdapter.marshal(task.getStartDate()));
        }
        if (task.getCompletionDate() != null) {
            writer.key("completionDate").value(this.timeAdapter.marshal(task.getCompletionDate()));
        }
        if (task.getScheduledDate() != null) {
            writer.key("scheduledDate").value(this.timeAdapter.marshal(task.getScheduledDate()));
        }
        writer.key("metadata").object();
        for (Map.Entry entry : task.getMetadata().entrySet()) {
            writer.key((String)entry.getKey()).value(entry.getValue());
        }
        writer.endObject();
        if (task instanceof TaskWithSteps) {
            this.writeSteps(writer, (TaskWithSteps)task);
        }
        writer.endObject();
        return writer.toString();
    }

    private void writeSteps(JsonWriter writer, TaskWithSteps task) {
        writer.key("steps");
        writer.array();
        for (StepState step : task.getSteps()) {
            this.stepConverter.writeJson(step, writer);
        }
        writer.endArray();
    }

    public TaskState toTask(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            String id = json.getString("id");
            int currentStepNr = json.getInt("currentStep");
            int nrSteps = json.getInt("totalSteps");
            TaskExecutionState2 state2 = TaskExecutionState2.valueOf((String)json.getString("state"));
            int failureCount = json.getInt("failures");
            String description = json.getString("description");
            DateTime startDate = null;
            if (json.has("startDate")) {
                startDate = this.timeAdapter.unmarshal(json.getString("startDate"));
            }
            DateTime completionDate = null;
            if (json.has("completionDate")) {
                completionDate = this.timeAdapter.unmarshal(json.getString("completionDate"));
            }
            DateTime scheduledDate = null;
            if (json.has("scheduledDate")) {
                scheduledDate = this.timeAdapter.unmarshal(json.getString("completionDate"));
            }
            LinkedHashMap metadata = Maps.newLinkedHashMap();
            JSONObject metadataJson = json.getJSONObject("metadata");
            Iterator iter = metadataJson.keys();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                metadata.put(key, metadataJson.getString(key));
            }
            return this.createTask(id, currentStepNr, nrSteps, state2, failureCount, description, startDate, completionDate, scheduledDate, metadata);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }

    protected abstract TaskState createTask(String var1, int var2, int var3, TaskExecutionState2 var4, int var5, String var6, DateTime var7, DateTime var8, DateTime var9, Map<String, String> var10);
}

