/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.rules;

import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.deployment.rules.OldRule;
import com.xebialabs.deployit.plugin.api.Deprecations;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContributorInvokerRule
extends OldRule<Deltas> {
    private Method contributor;
    private static final Logger logger = LoggerFactory.getLogger(ContributorInvokerRule.class);

    public ContributorInvokerRule(Method contributor) {
        super(ContributorInvokerRule.buildName(contributor), true);
        this.contributor = contributor;
    }

    private static String buildName(Method contributor) {
        return String.format("%s.%s", contributor.getDeclaringClass().getName(), contributor.getName());
    }

    @Override
    public boolean canFire(Deltas deltas, DeploymentPlanningContext context) {
        return true;
    }

    @Override
    public void fire(Deltas deltas, DeploymentPlanningContext context) {
        try {
            if (Modifier.isStatic(this.contributor.getModifiers())) {
                this.contributor.invoke(null, deltas, context);
            } else {
                Deprecations.deprecated((String)"Non-static contributors are considered deprecated, consider making [%s] static", (Object[])new Object[]{this.contributor});
                Object contributorInstance = this.contributor.getDeclaringClass().newInstance();
                this.contributor.invoke(contributorInstance, deltas, context);
            }
        }
        catch (InstantiationException e) {
            throw new DeploymentPlanner.PlannerException(e);
        }
        catch (IllegalAccessException e) {
            throw new DeploymentPlanner.PlannerException(e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e, (String)"");
        }
    }
}

