/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.actor.ActorSystem;
import akka.event.BusLogging;
import akka.event.LogSource;
import akka.event.LogSource$;
import akka.event.Logging;
import akka.event.Logging$Error$NoCause$;
import akka.event.Logging$LoggerInitialized$;
import akka.event.LoggingAdapter;
import akka.event.LoggingBus;
import java.io.PrintWriter;
import java.io.StringWriter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.util.control.NoStackTrace;

public final class Logging$ {
    public static final Logging$ MODULE$;
    private final int ErrorLevel;
    private final int WarningLevel;
    private final int InfoLevel;
    private final int DebugLevel;
    private final int OffLevel;
    private final scala.collection.immutable.Seq<Logging.LogLevel> AllLogLevels;
    private final Logging.StandardOutLogger StandardOutLogger;

    static {
        new Logging$();
    }

    public String simpleName(Object obj) {
        return this.simpleName(obj.getClass());
    }

    public String simpleName(Class<?> clazz) {
        String n = clazz.getName();
        int i = n.lastIndexOf(46);
        return n.substring(i + 1);
    }

    public final int ErrorLevel() {
        return this.ErrorLevel;
    }

    public final int WarningLevel() {
        return this.WarningLevel;
    }

    public final int InfoLevel() {
        return this.InfoLevel;
    }

    public final int DebugLevel() {
        return this.DebugLevel;
    }

    private final int OffLevel() {
        return this.OffLevel;
    }

    public Option<Logging.LogLevel> levelFor(String s) {
        Object object;
        String string;
        String string2 = string = s.toLowerCase();
        if (!("off" != null ? !"off".equals(string2) : string2 != null)) {
            object = new Some((Object)new Logging.LogLevel(this.OffLevel()));
        } else {
            String string3 = string;
            if (!("error" != null ? !"error".equals(string3) : string3 != null)) {
                object = new Some((Object)new Logging.LogLevel(this.ErrorLevel()));
            } else {
                String string4 = string;
                if (!("warning" != null ? !"warning".equals(string4) : string4 != null)) {
                    object = new Some((Object)new Logging.LogLevel(this.WarningLevel()));
                } else {
                    String string5 = string;
                    if (!("info" != null ? !"info".equals(string5) : string5 != null)) {
                        object = new Some((Object)new Logging.LogLevel(this.InfoLevel()));
                    } else {
                        String string6 = string;
                        object = !("debug" != null ? !"debug".equals(string6) : string6 != null) ? new Some((Object)new Logging.LogLevel(this.DebugLevel())) : None$.MODULE$;
                    }
                }
            }
        }
        return object;
    }

    public int levelFor(Class<? extends Logging.LogEvent> eventClass) {
        return Logging.Error.class.isAssignableFrom(eventClass) ? this.ErrorLevel() : (Logging.Warning.class.isAssignableFrom(eventClass) ? this.WarningLevel() : (Logging.Info.class.isAssignableFrom(eventClass) ? this.InfoLevel() : (Logging.Debug.class.isAssignableFrom(eventClass) ? this.DebugLevel() : this.DebugLevel())));
    }

    public Class<? extends Logging.LogEvent> classFor(int level) {
        int n;
        block6: {
            Class clazz;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            n = level;
                            if (this.ErrorLevel() != n) break block2;
                            clazz = Logging.Error.class;
                            break block3;
                        }
                        if (this.WarningLevel() != n) break block4;
                        clazz = Logging.Warning.class;
                        break block3;
                    }
                    if (this.InfoLevel() != n) break block5;
                    clazz = Logging.Info.class;
                    break block3;
                }
                if (this.DebugLevel() != n) break block6;
                clazz = Logging.Debug.class;
            }
            return clazz;
        }
        throw new MatchError((Object)new Logging.LogLevel(n));
    }

    public scala.collection.immutable.Seq<Logging.LogLevel> AllLogLevels() {
        return this.AllLogLevels;
    }

    public <T> LoggingAdapter apply(ActorSystem system, T logSource, LogSource<T> evidence$3) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$3);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = (String)tuple2._1();
            Class clazz = (Class)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)str, (Object)clazz);
            String str2 = (String)tuple23._1();
            Class clazz2 = (Class)tuple23._2();
            return new BusLogging(system.eventStream(), str2, clazz2);
        }
        throw new MatchError(tuple2);
    }

    public <T> LoggingAdapter apply(LoggingBus bus, T logSource, LogSource<T> evidence$4) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$4);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = (String)tuple2._1();
            Class clazz = (Class)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)str, (Object)clazz);
            String str2 = (String)tuple23._1();
            Class clazz2 = (Class)tuple23._2();
            return new BusLogging(bus, str2, clazz2);
        }
        throw new MatchError(tuple2);
    }

    public LoggingAdapter getLogger(ActorSystem system, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource, system);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = (String)tuple2._1();
            Class clazz = (Class)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)str, (Object)clazz);
            String str2 = (String)tuple23._1();
            Class clazz2 = (Class)tuple23._2();
            return new BusLogging(system.eventStream(), str2, clazz2);
        }
        throw new MatchError(tuple2);
    }

    public LoggingAdapter getLogger(LoggingBus bus, Object logSource) {
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String str = (String)tuple2._1();
            Class clazz = (Class)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)str, (Object)clazz);
            String str2 = (String)tuple23._1();
            Class clazz2 = (Class)tuple23._2();
            return new BusLogging(bus, str2, clazz2);
        }
        throw new MatchError(tuple2);
    }

    public Logging$Error$NoCause$ noCause() {
        return Logging$Error$NoCause$.MODULE$;
    }

    public Logging$LoggerInitialized$ loggerInitialized() {
        return Logging$LoggerInitialized$.MODULE$;
    }

    public Logging.StandardOutLogger StandardOutLogger() {
        return this.StandardOutLogger;
    }

    public String stackTraceFor(Throwable e) {
        String string;
        boolean bl;
        Throwable throwable = e;
        if (throwable == null) {
            bl = true;
        } else {
            Logging$Error$NoCause$ logging$Error$NoCause$ = Logging$Error$NoCause$.MODULE$;
            Throwable throwable2 = throwable;
            bl = !(logging$Error$NoCause$ != null ? !logging$Error$NoCause$.equals(throwable2) : throwable2 != null);
        }
        if (bl) {
            string = "";
        } else if (throwable instanceof NoStackTrace) {
            string = new StringBuilder().append((Object)" (").append((Object)e.getClass().getName()).append((Object)")").toString();
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.append('\n');
            throwable.printStackTrace(pw);
            string = sw.toString();
        }
        return string;
    }

    private Logging$() {
        MODULE$ = this;
        this.ErrorLevel = 1;
        this.WarningLevel = 2;
        this.InfoLevel = 3;
        this.DebugLevel = 4;
        this.OffLevel = Integer.MIN_VALUE;
        this.AllLogLevels = (scala.collection.immutable.Seq)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Logging.LogLevel[]{new Logging.LogLevel(this.ErrorLevel()), new Logging.LogLevel(this.WarningLevel()), new Logging.LogLevel(this.InfoLevel()), new Logging.LogLevel(this.DebugLevel())}));
        this.StandardOutLogger = new Logging.StandardOutLogger();
    }
}

