/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit;

import com.google.common.base.Predicate;
import de.schlichtherle.truezip.file.TFile;
import java.net.URI;
import java.util.Set;
import javassist.bytecode.ClassFile;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.metadata.JavassistHelper;
import nl.javadude.scannit.reader.ArchiveEntrySupplier;
import nl.javadude.scannit.reader.ClasspathReader;
import nl.javadude.scannit.registry.Registry;
import nl.javadude.scannit.scanner.AbstractScanner;

class Worker {
    private Configuration configuration;
    private Registry registry;

    Worker(Configuration configuration, Registry registry) {
        this.configuration = configuration;
        this.registry = registry;
    }

    void scan() {
        ClasspathReader reader = new ClasspathReader();
        for (String prefix : this.configuration.prefixes) {
            Set<URI> baseURIs = reader.findBaseURIs(prefix);
            this.scanURI(baseURIs);
        }
    }

    private void scanURI(Set<URI> baseURIs) {
        for (URI baseURI : baseURIs) {
            ArchiveEntrySupplier entrySupplier = new ArchiveEntrySupplier(baseURI);
            this.scanFiles(entrySupplier);
        }
    }

    private void scanFiles(ArchiveEntrySupplier entrySupplier) {
        entrySupplier.withArchiveEntries(new Predicate<TFile>(){

            public boolean apply(TFile tFile) {
                if (tFile.getName().endsWith(".class")) {
                    ClassFile classFile = JavassistHelper.readFile(tFile);
                    Worker.this.scanFile(classFile);
                }
                return true;
            }
        });
    }

    private void scanFile(ClassFile classFile) {
        for (AbstractScanner scanner : this.configuration.scanners) {
            scanner.scan(classFile, this.registry);
        }
    }
}

