/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.orchestrator;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

@Orchestrator.Metadata(name="group-based", description="Enforce a deployment order based on the deployment group property")
public class GroupBasedOrchestrator
implements Orchestrator {
    private final Function<Delta, Integer> groupByGroupNumber = new Function<Delta, Integer>(){

        public Integer apply(Delta input) {
            Container container = GroupBasedOrchestrator.getDeployed(input).getContainer();
            Integer deploymentGroup = Integer.MIN_VALUE;
            if (container.hasProperty("deploymentGroup")) {
                deploymentGroup = (Integer)container.getProperty("deploymentGroup");
            }
            if (deploymentGroup == null) {
                deploymentGroup = Integer.MIN_VALUE;
            }
            return deploymentGroup;
        }
    };
    private final Function<Delta, Container> deltaToContainer = new Function<Delta, Container>(){

        public Container apply(Delta input) {
            return GroupBasedOrchestrator.getDeployed(input).getContainer();
        }
    };
    private final Function<Collection<Delta>, Orchestration> deltasToInterleaved = new Function<Collection<Delta>, Orchestration>(){

        public Orchestration apply(Collection<Delta> input) {
            return Orchestrations.interleaved((List)Lists.newArrayList(input));
        }
    };
    private final Function<Collection<Delta>, Orchestration> collectParallelGroups = new Function<Collection<Delta>, Orchestration>(){

        public Orchestration apply(Collection<Delta> group) {
            return Orchestrations.parallel((List)Lists.newArrayList((Iterable)Iterables.transform((Iterable)Multimaps.index(group, (Function)GroupBasedOrchestrator.this.deltaToContainer).asMap().values(), (Function)GroupBasedOrchestrator.this.deltasToInterleaved)));
        }
    };

    public Orchestration orchestrate(DeltaSpecification specification) {
        TreeMap treeMap = new TreeMap();
        treeMap.putAll(Multimaps.index((Iterable)specification.getDeltas(), this.groupByGroupNumber).asMap());
        Collection interleavedPlan = specification.getDeployedApplication().isParallelByContainer() ? Collections2.transform(treeMap.values(), this.collectParallelGroups) : Collections2.transform(treeMap.values(), this.deltasToInterleaved);
        return Orchestrations.serial((List)Lists.newArrayList((Iterable)interleavedPlan));
    }

    private static Deployed<?, ?> getDeployed(Delta input) {
        return input.getDeployed() != null ? input.getDeployed() : input.getPrevious();
    }
}

