/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState2;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class ArchivedTask
implements TaskWithSteps {
    private List<StepState> steps = Lists.newArrayList();
    private TaskExecutionState2 state;
    private String id;
    private String description;
    private DateTime startDate;
    private DateTime completionDate;
    private List<Integer> currentStepNrs = Lists.newArrayList();
    private Map<String, String> metadata = Maps.newHashMap();
    private int failureCount;
    private String owner;

    public List<StepState> getSteps() {
        return this.steps;
    }

    public StepState getStep(int stepNr) {
        Preconditions.checkArgument((stepNr > 0 && stepNr <= this.steps.size() ? 1 : 0) != 0, (String)"Not a valid step number [%s]", (Object[])new Object[]{stepNr});
        return this.steps.get(stepNr - 1);
    }

    @Deprecated
    public TaskExecutionState getState() {
        return this.state.toTaskExecutionState();
    }

    public TaskExecutionState2 getState2() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public DateTime getScheduledDate() {
        return null;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getCompletionDate() {
        return this.completionDate;
    }

    public int getNrSteps() {
        return this.steps.size();
    }

    @Deprecated
    public int getCurrentStepNr() {
        return (Integer)Iterables.getFirst(this.currentStepNrs, (Object)0);
    }

    public List<Integer> getCurrentStepNrs() {
        return this.currentStepNrs;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setSteps(List<StepState> steps) {
        this.steps = steps;
    }

    public void setState2(TaskExecutionState2 state) {
        this.state = state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public void setCompletionDate(DateTime completionDate) {
        this.completionDate = completionDate;
    }

    @Deprecated
    public void setCurrentStepNr(int currentStepNr) {
        this.currentStepNrs = Lists.newArrayList((Object[])new Integer[]{currentStepNr});
    }

    public void setCurrentStepNrs(List<Integer> currentStepNrs) {
        this.currentStepNrs = currentStepNrs;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}

