/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.util.TFiles;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

class PackageScanner {
    private static final Logger logger = LoggerFactory.getLogger(PackageScanner.class);

    PackageScanner() {
    }

    static Set<String> scan(File directory, Predicate<File> isPackage) {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Directory " + directory.getAbsolutePath() + " does not exist or is not a directory");
        }
        HashSet result = Sets.newHashSet();
        logger.debug("Listing importable packages in {}", (Object)directory.getAbsolutePath());
        PackageScanner.scanDirectory(directory, result, "", isPackage);
        logger.debug("Returning the following packages: {}", (Object)result);
        return result;
    }

    private static void scanDirectory(File directory, Set<String> result, String pathPrefix, Predicate<File> isPackage) {
        File[] files = directory.listFiles();
        logger.debug("Found {} possible packages.", (Object)files.length);
        for (File f : files) {
            if (isPackage.apply((Object)f)) {
                result.add(pathPrefix + f.getName());
                continue;
            }
            if (!f.isDirectory()) continue;
            PackageScanner.scanDirectory(f, result, pathPrefix + f.getName() + "/", isPackage);
        }
    }

    static boolean isDarPackage(File f) {
        return f.isFile() && StringUtils.endsWithIgnoreCase((String)f.getName(), (String)".dar");
    }

    static boolean isXmlManifestPackage(File f) {
        return (PackageScanner.isDarPackage(f) || f.isDirectory()) && PackageScanner.containsXmlManifest(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsXmlManifest(File f) {
        TFile tFile = new TFile(f);
        try {
            boolean bl = new TFile((File)tFile, "deployit-manifest.xml").exists();
            return bl;
        }
        finally {
            TFiles.umountQuietly((TFile)tFile);
        }
    }

    static boolean isManifestMfPackage(File f) {
        return (PackageScanner.isDarPackage(f) || f.isDirectory()) && PackageScanner.containsMfManifest(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsMfManifest(File f) {
        TFile tFile = new TFile(f);
        try {
            boolean bl = new TFile((File)new TFile((File)tFile, "META-INF"), "MANIFEST.MF").exists();
            return bl;
        }
        finally {
            TFiles.umountQuietly((TFile)tFile);
        }
    }

    static boolean isExplodedPackage(File f) {
        if (f.isDirectory()) {
            File manifestFile = PackageScanner.getManifestFileForUnpackedPackage(f);
            return manifestFile.exists();
        }
        return false;
    }

    static File getManifestFileForUnpackedPackage(File f) {
        File manifestFile = new File(new File(f, "META-INF"), "MANIFEST.MF");
        return manifestFile;
    }

    public static TFile getManifestFileFromImportSource(ImportSource source) {
        File file = source.getFile();
        return new TFile((File)new TFile(file, "META-INF"), "MANIFEST.MF");
    }
}

