/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState2;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.Transitions;
import com.xebialabs.deployit.inspection.Inspector;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.service.discovery.DiscoveryContext;
import com.xebialabs.deployit.service.discovery.DiscoveryResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryTrigger
implements ExecutionStateListener {
    private DiscoveryContext context;
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryTrigger.class);

    public DiscoveryTrigger(DiscoveryContext context) {
        this.context = context;
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
        if (Transitions.checkTransition((StepExecutionStateEvent)event, (StepExecutionState)StepExecutionState.EXECUTING, (StepExecutionState)StepExecutionState.DONE)) {
            logger.debug("Checking whether we need to add more steps for recently discovered items.");
            this.addStepsForDiscoveredItems();
        }
    }

    private void addStepsForDiscoveredItems() {
        for (ConfigurationItem ci : Lists.newArrayList(this.context.getDiscovered().values())) {
            Inspector.inspect((ConfigurationItem)ci, (InspectionContext)this.context);
        }
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState2)TaskExecutionState2.EXECUTING, (TaskExecutionState2)TaskExecutionState2.EXECUTED)) {
            logger.info("Registering inspection results of task [{}]", (Object)event.task().getId());
            DiscoveryResults.register((TaskState)event.task(), Lists.newArrayList(this.context.getInspected().values()));
        }
    }
}

