/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState2;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.Transitions;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemCloner;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialCommitTrigger
implements ExecutionStateListener {
    private DeltaSpecification specification;
    private DeployedApplication inprogressDeployedApplication;
    private Set<StepPlan.Checkpoint> checkpoints;
    private List<StepPlan.Checkpoint> checkpointed = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(PartialCommitTrigger.class);

    public PartialCommitTrigger(DeltaSpecification specification, Set<StepPlan.Checkpoint> checkpoints) {
        this.specification = specification;
        if (specification.getOperation() == Operation.CREATE) {
            this.inprogressDeployedApplication = (DeployedApplication)ConfigurationItemCloner.cloneShallow((ConfigurationItem)specification.getDeployedApplication());
            this.inprogressDeployedApplication.getDeployeds().clear();
        } else {
            this.inprogressDeployedApplication = (DeployedApplication)ConfigurationItemCloner.cloneShallow((ConfigurationItem)specification.getPreviousDeployedApplication());
        }
        this.checkpoints = checkpoints;
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
        logger.debug("Got event [{}]", (Object)event);
        final TaskStep step = (TaskStep)event.step();
        if (!step.getState().isFinal()) {
            return;
        }
        Iterable matchingCheckpoints = Iterables.filter(this.checkpoints, (Predicate)new Predicate<StepPlan.Checkpoint>(){

            public boolean apply(StepPlan.Checkpoint input) {
                return input.getStep().equals(step.getImplementation());
            }
        });
        logger.debug("Found steps: [{}]", (Object)matchingCheckpoints);
        for (StepPlan.Checkpoint checkpoint : matchingCheckpoints) {
            this.makeCheckpoint(checkpoint);
        }
    }

    private void makeCheckpoint(final StepPlan.Checkpoint checkpoint) {
        logger.debug("Checkpointing... {}", (Object)checkpoint);
        Optional optionalCheckpoint = Iterables.tryFind(this.checkpointed, (Predicate)new Predicate<StepPlan.Checkpoint>(){

            public boolean apply(StepPlan.Checkpoint input) {
                return input.getDelta().equals(checkpoint.getDelta());
            }
        });
        boolean added = false;
        if (optionalCheckpoint.isPresent()) {
            StepPlan.Checkpoint foundCheckpoint = (StepPlan.Checkpoint)optionalCheckpoint.get();
            this.checkpointed.remove(foundCheckpoint);
            if (foundCheckpoint.getDelta().getOperation() == Operation.MODIFY) {
                added = this.doModifyCheckpoint(foundCheckpoint, checkpoint);
            }
        }
        if (!added) {
            this.checkpointed.add(checkpoint);
        }
    }

    private boolean doModifyCheckpoint(StepPlan.Checkpoint foundCheckpoint, StepPlan.Checkpoint checkpoint) {
        if (foundCheckpoint.getOperation() == Operation.DESTROY && checkpoint.getOperation() == Operation.CREATE) {
            this.checkpointed.add(new StepPlan.Checkpoint(checkpoint.getDelta(), checkpoint.getStep()));
            return true;
        }
        return false;
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState2)TaskExecutionState2.STOPPED, (TaskExecutionState2)TaskExecutionState2.CANCELLED) || Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState2)TaskExecutionState2.FAILED, (TaskExecutionState2)TaskExecutionState2.CANCELLED) || Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState2)TaskExecutionState2.ABORTED, (TaskExecutionState2)TaskExecutionState2.CANCELLED)) {
            logger.info("Partial commit triggered");
            this.doPartialCommit();
        }
    }

    private void doPartialCommit() {
        logger.debug("Checkpointing: {}", this.checkpointed);
        if (this.specification.getOperation() == Operation.CREATE && this.checkpointed.isEmpty()) {
            return;
        }
        ChangeSet cs = new ChangeSet();
        for (StepPlan.Checkpoint checkpoint : this.checkpointed) {
            Deployed deployed = checkpoint.getDelta().getDeployed();
            Deployed previousDeployed = checkpoint.getDelta().getPrevious();
            switch (checkpoint.getOperation()) {
                case CREATE: {
                    this.inprogressDeployedApplication.addDeployed(deployed);
                    cs.createOrUpdate((ConfigurationItem)deployed);
                    break;
                }
                case MODIFY: 
                case NOOP: {
                    this.inprogressDeployedApplication.getDeployeds().remove(previousDeployed);
                    this.inprogressDeployedApplication.addDeployed(deployed);
                    cs.createOrUpdate((ConfigurationItem)deployed);
                    break;
                }
                case DESTROY: {
                    this.inprogressDeployedApplication.getDeployeds().remove(previousDeployed);
                    cs.delete((ConfigurationItem)previousDeployed);
                }
            }
        }
        if (this.inprogressDeployedApplication.getDeployeds().isEmpty()) {
            cs.delete((ConfigurationItem)this.inprogressDeployedApplication);
        } else {
            cs.createOrUpdate((ConfigurationItem)this.inprogressDeployedApplication);
        }
        logger.info("Storing the partial commit");
        RepositoryServiceHolder.getRepositoryService().execute(cs);
        logger.info("Stored the partial commit");
    }

    DeltaSpecification getSpecification() {
        return this.specification;
    }

    DeployedApplication getInprogressDeployedApplication() {
        return this.inprogressDeployedApplication;
    }
}

