/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.xebialabs.deployit.jetty.FlexRestCompatibilityServletRequest;
import com.xebialabs.deployit.jetty.FlexRestCompatibilityServletResponse;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexRestCompatibilityFilter
implements Filter {
    protected static final String X_FLEX_REST = "X-Flex-Rest";
    public static final String X_ORIGINAL_STATUS_HEADER = "X-Original-Status";
    public static final String X_METHOD_OVERRIDE_HEADER = "X-HTTP-Method-Override";
    private static final Logger logger = LoggerFactory.getLogger(FlexRestCompatibilityFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("Added FlexRestCompatibilityFilter to the mix.");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean installResponseCompatibilityLayer = false;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hsr = (HttpServletRequest)request;
            String brokenRest = hsr.getHeader(X_FLEX_REST);
            installResponseCompatibilityLayer = brokenRest != null && !"".equals(brokenRest);
        }
        request = new FlexRestCompatibilityServletRequest((HttpServletRequest)request, X_METHOD_OVERRIDE_HEADER);
        if (installResponseCompatibilityLayer) {
            logger.debug("Setting Flex Compatibility mode.");
            response = new FlexRestCompatibilityServletResponse((HttpServletResponse)response);
            ((FlexRestCompatibilityServletResponse)((Object)response)).writePreamble();
        }
        chain.doFilter(request, response);
        if (installResponseCompatibilityLayer) {
            ((FlexRestCompatibilityServletResponse)((Object)response)).writePostamble();
        }
    }

    public void destroy() {
    }
}

