/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import java.util.List;

public class Dictionaries {
    private List<Dictionary> dictionaries = Lists.newArrayList();
    private Application application;
    private Container container;

    private Dictionaries(List<Dictionary> dictionaries, Application application, Container container) {
        this.dictionaries = dictionaries;
        this.application = application;
        this.container = container;
    }

    public static Dictionaries of(List<Dictionary> dictionaries) {
        return new Dictionaries(dictionaries, null, null);
    }

    public Dictionaries filterBy(Application application) {
        return new Dictionaries(this.dictionaries, application, this.container);
    }

    public Dictionaries filterBy(Container container) {
        return new Dictionaries(this.dictionaries, this.application, container);
    }

    public ConsolidatedDictionary consolidate() {
        Checks.checkNotNull(this.application, "application");
        return ConsolidatedDictionary.create(Lists.newArrayList((Iterable)Iterables.filter(this.dictionaries, (Predicate)new Predicate<Dictionary>(){

            public boolean apply(Dictionary input) {
                return Dictionaries.this.isApplicableTo(input, Dictionaries.this.application, Dictionaries.this.container);
            }
        })));
    }

    private boolean isApplicableTo(Dictionary dict, Application app, Container container) {
        boolean appMatches = dict.getRestrictToApplications().isEmpty() || dict.getRestrictToApplications().contains(app);
        boolean containerMatches = dict.getRestrictToContainers().isEmpty() || container != null && dict.getRestrictToContainers().contains(container);
        return appMatches && containerMatches;
    }
}

