/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.gc;

import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import java.lang.reflect.Field;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.data.GarbageCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGarbageCollectionStep
implements Step {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGarbageCollectionStep.class);

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Running garbage collection on the repository";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        logger.info("Running garbage collector to compact the DataStore");
        try {
            JcrTemplate jcrTemplate = JcrTemplateHolder.get();
            Field repositoryField = JcrTemplate.class.getDeclaredField("repository");
            repositoryField.setAccessible(true);
            Repository repository = (Repository)repositoryField.get(jcrTemplate);
            Session garbageCollectionSession = repository.login((Credentials)new SimpleCredentials("anonymous", "".toCharArray()));
            try {
                GarbageCollector gc = ((RepositoryImpl)repository).createDataStoreGarbageCollector();
                try {
                    gc.mark();
                    gc.sweep();
                }
                finally {
                    gc.close();
                }
            }
            finally {
                garbageCollectionSession.logout();
            }
            logger.info("Garbage collector completed");
        }
        catch (RepositoryException exc) {
            logger.error("Cannot run the gargage collector", (Throwable)exc);
        }
        return StepExitCode.SUCCESS;
    }
}

