/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.base.Strings;
import com.xebialabs.deployit.CustomErrorHandler;
import com.xebialabs.deployit.DeployitConfig;
import com.xebialabs.deployit.DeployitConfiguration;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.core.rest.resteasy.Mime4jStorageProvider;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jetty.ClassPathResourceContentServlet;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.deployit.jetty.FlexRestCompatibilityFilter;
import com.xebialabs.deployit.jetty.NoOptionsFilter;
import com.xebialabs.deployit.jetty.RequestHeadersEncodedAsParametersFilter;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.filter.LicenseCheckFilter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.Provider;
import java.security.Security;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.crypto.SecretKey;
import javax.jcr.Repository;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import nl.javadude.t2bus.Subscribe;
import org.apache.jackrabbit.j2ee.JcrRemotingServlet;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ErrorHandler;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.DelegatingFilterProxy;

public class Server {
    private final DeployitConfig deployItConfiguration;
    private final String name;
    private final String springConfig;
    private final String contextPath;
    private org.mortbay.jetty.Server jettyServer;
    private Context contextRoot;
    private static volatile CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static final Logger logger = LoggerFactory.getLogger(Server.class);

    public static void start(String name, DeployitOptions deployitOptions) {
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)deployitOptions.getRepositoryKeystorePassword());
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            System.out.println("Could not load the encryption key. " + name + " will not start.");
            return;
        }
        DeployitConfiguration.load();
        Server server = new Server(name, DeployitConfiguration.getInstance(), deployitOptions);
        server.start();
    }

    public Server(String name, DeployitConfig configuration, DeployitOptions deployitOptions) {
        this(name, configuration, deployitOptions, "classpath:spring/deployit-context.xml,classpath:deployit-security.xml,classpath*:hotfix-context.xml", "deployit");
    }

    public Server(String name, DeployitConfig configuration, DeployitOptions deployitOptions, String springConfig, String contextPath) {
        this.deployItConfiguration = configuration;
        this.name = name;
        this.springConfig = springConfig;
        this.contextPath = contextPath;
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (this.portIsAvailable()) {
            this.setupJetty(deployitOptions);
            Server.bootPlugins();
            this.setupSpring();
            this.setupRest();
        } else {
            logger.error("Cannot start {}; port {} already in use.", (Object)name, (Object)this.deployItConfiguration.getHttpPort());
            logger.error("Perhaps another instance of {} is running.", (Object)name);
            System.exit(1);
        }
    }

    private boolean portIsAvailable() {
        try {
            ServerSocket socket = new ServerSocket(this.deployItConfiguration.getHttpPort());
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void setupJetty(DeployitOptions deployitOptions) {
        int port = this.deployItConfiguration.getHttpPort();
        String webContextRoot = this.deployItConfiguration.getWebContextRoot();
        String documentRootPackage = "web";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up Jetty server on port {} with context root {} using package {} for document root.", new Object[]{port, webContextRoot, documentRootPackage});
        }
        this.jettyServer = new org.mortbay.jetty.Server();
        SocketConnector connector = new SocketConnector();
        if (this.deployItConfiguration.isSsl()) {
            logger.debug("Setting up Jetty to use SSL");
            SslSocketConnector sslConnector = new SslSocketConnector();
            connector.setMaxIdleTime(30000);
            sslConnector.setKeystore(this.deployItConfiguration.getKeyStorePath());
            sslConnector.setPassword(this.deployItConfiguration.getKeyStorePassword());
            sslConnector.setKeyPassword(this.deployItConfiguration.getKeyStoreKeyPassword());
            String protocol = this.deployItConfiguration.getSslProtocol();
            if (!Strings.nullToEmpty((String)protocol).trim().isEmpty()) {
                sslConnector.setProtocol(protocol);
            }
            connector = sslConnector;
        }
        connector.setHost(this.deployItConfiguration.getHttpBindAddress());
        connector.setPort(port);
        logger.info("Connector listen {} on {}:{}", new Object[]{this.deployItConfiguration.isSsl() ? "secure" : "no-secure", connector.getHost(), connector.getPort()});
        this.jettyServer.addConnector((Connector)connector);
        BoundedThreadPool btp = new BoundedThreadPool();
        btp.setMinThreads(this.deployItConfiguration.getMinThreads());
        btp.setMaxThreads(this.deployItConfiguration.getMaxThreads());
        this.jettyServer.setThreadPool((ThreadPool)btp);
        this.jettyServer.setGracefulShutdown(1000);
        this.contextRoot = new Context((HandlerContainer)this.jettyServer, webContextRoot, 0);
        this.contextRoot.addFilter(LicenseCheckFilter.class, "*", 0);
        this.contextRoot.addFilter(NoOptionsFilter.class, "*", 0);
        this.contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/reports/*", 0);
        this.contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/repository/*", 0);
        this.contextRoot.addFilter(FlexRestCompatibilityFilter.class, "*", 0);
        ServletHolder defaultServletHolder = new ServletHolder();
        defaultServletHolder.setServlet((Servlet)new ClassPathResourceContentServlet(documentRootPackage));
        defaultServletHolder.setInitParameter("dirAllowed", "false");
        this.contextRoot.addServlet(defaultServletHolder, "/");
        this.contextRoot.setErrorHandler((ErrorHandler)new CustomErrorHandler());
        if (deployitOptions.isTestModeEnabled()) {
            this.setupJackRabbitAccess();
        }
    }

    private void setupJackRabbitAccess() {
        ServletHolder remotingServletHolder = new ServletHolder((Servlet)new JcrRemotingServlet(){

            protected Repository getRepository() {
                WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                return (Repository)context.getBean("jcrRepository");
            }
        });
        remotingServletHolder.setName("RepositoryAccessServlet");
        String repositoryPrefix = "/repository-test";
        remotingServletHolder.setInitParameter("resource-path-prefix", repositoryPrefix);
        this.contextRoot.addServlet(remotingServletHolder, repositoryPrefix + "/*");
        ServletHolder webdavServletHolder = new ServletHolder((Servlet)new JcrRemotingServlet(){

            public Repository getRepository() {
                WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
                return (Repository)context.getBean("jcrRepository");
            }
        });
        webdavServletHolder.setName("Webdav");
        repositoryPrefix = "/repository";
        webdavServletHolder.setInitParameter("resource-path-prefix", repositoryPrefix);
        webdavServletHolder.setInitParameter("missing-auth-mapping", "guestcredentials");
        this.contextRoot.addServlet(webdavServletHolder, repositoryPrefix + "/*");
    }

    private static void bootPlugins() {
        LocalBooter.boot();
    }

    private void setupSpring() {
        Map params = this.contextRoot.getInitParams();
        params.put("contextConfigLocation", this.springConfig);
        if (logger.isDebugEnabled()) {
            logger.debug("Using Spring configuration - " + (String)params.get("contextConfigLocation"));
        }
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        this.contextRoot.addFilter(filter, "/" + this.contextPath + "/*", 1);
    }

    private void setupRest() {
        this.contextRoot.addEventListener((EventListener)new ResteasyBootstrap());
        this.contextRoot.addEventListener((EventListener)((Object)new DeployitSpringContextLoaderListener()));
        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        this.contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/" + this.contextPath);
        this.contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
        this.contextRoot.addServlet(servletHolder, "/" + this.contextPath + "/*");
        this.contextRoot.setResourceBase(".");
        DefaultStorageProvider.setInstance((StorageProvider)new Mime4jStorageProvider());
    }

    public void start() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Jetty");
            }
            this.jettyServer.start();
            DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
            if (logger.isDebugEnabled()) {
                logger.debug("Jetty started");
            }
            logger.info("{} has started.", (Object)this.name);
            this.createShutdownEventThreadAndShutdownHook();
            String host = (this.deployItConfiguration.isSsl() ? "https" : "http") + "://" + InetAddress.getLocalHost().getHostName() + ":" + this.deployItConfiguration.getHttpPort() + this.deployItConfiguration.getWebContextRoot();
            logger.info("You can now point your browser to {}", (Object)host);
            EventBusHolder.publish((Object)new SystemStartedEvent());
        }
        catch (Exception e) {
            logger.error("Error occured while starting Jetty", (Throwable)e);
            this.stop();
        }
    }

    private synchronized void stop() {
        if (this.jettyServer.isRunning()) {
            logger.info("Shutting down {}.", (Object)this.name);
            try {
                this.jettyServer.stop();
                logger.info("{} has shut down.", (Object)this.name);
            }
            catch (Exception e) {
                logger.error("Error occurred while trying to stop Jetty", (Throwable)e);
            }
        }
    }

    private void createShutdownEventThreadAndShutdownHook() {
        Thread shutdownEventThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shutdownLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.trace("Shutting down {} because a shutdown event was received.", (Object)Server.this.name);
                Server.this.stop();
            }
        });
        shutdownEventThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                logger.trace("Shutting down {} because the process is being terminated.", (Object)Server.this.name);
                Server.this.stop();
            }
        }));
        EventBusHolder.register((Object)this);
    }

    public Context getContextRoot() {
        return this.contextRoot;
    }

    @Subscribe
    public void shutdownListener(ShutdownEvent event) {
        logger.trace("Received shutdown event.");
        shutdownLatch.countDown();
    }
}

