/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedService {
    private DeployedGenerator deployedGenerator;
    private TypeCalculator typeCalculator;
    private static final Logger logger = LoggerFactory.getLogger(DeployedService.class);

    @Autowired
    public DeployedService(DeployedGenerator deployedGenerator, TypeCalculator typeCalculator) {
        this.deployedGenerator = deployedGenerator;
        this.typeCalculator = typeCalculator;
    }

    public ListMultimap<Boolean, ConfigurationItem> generateAllDeployeds(Version pkg, Environment env) {
        Set containers = env.getMembers();
        Dictionaries dictionaries = Dictionaries.of((List)env.getDictionaries()).filterBy(pkg.getApplication());
        List<Deployed> validDeployeds = this.generateDeployedsOfType(pkg.getDeployables(), containers, null, dictionaries);
        if (validDeployeds.isEmpty()) {
            throw new Checks.IncorrectArgumentException("Could not generate any deployeds for " + pkg.getId() + " and " + env.getId(), new Object[0]);
        }
        return this.createValidDeployedMap(validDeployeds, Lists.newArrayList());
    }

    public DeployedApplication generateDeployedApplication(Version pkg, Environment env) {
        Dictionaries dictionaries = Dictionaries.of((List)env.getDictionaries()).filterBy(pkg.getApplication());
        return this.deployedGenerator.createDeployedApplication(pkg, env, dictionaries.consolidate());
    }

    public ListMultimap<Boolean, ConfigurationItem> generateSelectedDeployeds(List<ConfigurationItem> deployableCis, Version version, Environment env) {
        Set containers = env.getMembers();
        List deployables = Lists.transform(deployableCis, (Function)new Function<ConfigurationItem, Deployable>(){

            public Deployable apply(ConfigurationItem from) {
                Checks.checkArgument((boolean)(from instanceof Deployable), (String)"The entity %s is not a deployable", (Object[])new Object[]{from.getId()});
                return (Deployable)from;
            }
        });
        Dictionaries dictionaries = Dictionaries.of((List)env.getDictionaries()).filterBy(version.getApplication());
        return this.createValidDeployedMap(this.generateDeployedsOfType(deployables, containers, null, dictionaries), Lists.newArrayList());
    }

    public ListMultimap<Boolean, ConfigurationItem> createSelectedDeployed(Deployable deployable, Container container, Type deployedType, Version version, Environment env) {
        logger.debug("Creating deployed for [{}] and [{}]", (Object)deployable, (Object)container);
        Dictionaries dictionaries = Dictionaries.of((List)env.getDictionaries()).filterBy(version.getApplication());
        return this.createValidDeployedMap(this.generateDeployedsOfType(Lists.newArrayList((Object[])new Deployable[]{deployable}), Lists.newArrayList((Object[])new Container[]{container}), deployedType, dictionaries, true), Lists.newArrayList());
    }

    public ListMultimap<Boolean, ConfigurationItem> generateUpgradedDeployeds(Version newPackage, DeployedApplication deployment) {
        Environment environment = deployment.getEnvironment();
        ArrayList upgradeDeployeds = Lists.newArrayList();
        ArrayList oldDeployeds = Lists.newArrayList();
        Dictionaries dictionaries = Dictionaries.of((List)environment.getDictionaries()).filterBy(newPackage.getApplication());
        for (final Deployed deployed : deployment.getDeployeds()) {
            Collection filtered = Collections2.filter((Collection)newPackage.getDeployables(), (Predicate)new Predicate<Deployable>(){

                public boolean apply(Deployable input) {
                    return DeployedService.this.isSimilar(input, deployed.getDeployable());
                }
            });
            ConsolidatedDictionary dictionary = dictionaries.filterBy(deployed.getContainer()).consolidate();
            if (filtered.size() == 0) {
                oldDeployeds.add(this.deployedGenerator.generateUpgradedDeployed(deployed.getDeployable(), deployed, dictionary));
                continue;
            }
            if (filtered.size() == 1) {
                upgradeDeployeds.add(this.deployedGenerator.generateUpgradedDeployed((Deployable)filtered.iterator().next(), deployed, dictionary));
                continue;
            }
            throw new IllegalArgumentException(String.format("More than 1 applicable deployable found in new package for %s, will not fly.", deployed));
        }
        return this.createValidDeployedMap(upgradeDeployeds, oldDeployeds);
    }

    public DeployedApplication generateUpdateDeployedApplication(DeployedApplication deployedApplication, Version newVersion) {
        logger.debug("Creating upgrade deployed application from: [{}] with new version [{}]", (Object)deployedApplication, (Object)newVersion);
        Dictionaries dictionaries = Dictionaries.of((List)deployedApplication.getEnvironment().getDictionaries()).filterBy(newVersion.getApplication());
        return this.deployedGenerator.createUpgradeDeployedApplication(newVersion, deployedApplication, dictionaries.consolidate());
    }

    public ListMultimap<Boolean, ConfigurationItem> createDeployedsForNonExistingCombinations(Version version, Environment environment, HashSet<Deployed> deployeds) {
        Set deployables = version.getDeployables();
        Set members = environment.getMembers();
        Collection validExistingDeployeds = Collections2.filter(deployeds, (Predicate)new Predicate<Deployed>(){

            public boolean apply(Deployed input) {
                return input.getDeployable() != null;
            }
        });
        logger.debug("Valid existing deployeds: {}", (Object)validExistingDeployeds);
        ArrayList invalidExistingDeployeds = Lists.newArrayList((Iterable)Collections2.filter(deployeds, (Predicate)new Predicate<Deployed>(){

            public boolean apply(Deployed input) {
                return input.getDeployable() == null;
            }
        }));
        logger.debug("Invalid existing deployeds: {}", (Object)invalidExistingDeployeds);
        FilterSet filterSet = new FilterSet(validExistingDeployeds);
        Dictionaries dictionaries = Dictionaries.of((List)environment.getDictionaries()).filterBy(version.getApplication());
        List<Deployed> generatedDeployeds = this.generateDeployedsOfType(deployables, members, null, dictionaries);
        logger.debug("Going to filter previously present deployeds");
        for (Deployed generatedDeployed : generatedDeployeds) {
            filterSet.add(generatedDeployed);
        }
        return this.createValidDeployedMap(filterSet.getAllValidAsList(), invalidExistingDeployeds);
    }

    private ListMultimap<Boolean, ConfigurationItem> createValidDeployedMap(List<Deployed> validDeployeds, List<Deployed> invalidDeployeds) {
        ArrayListMultimap deployedsMap = ArrayListMultimap.create();
        deployedsMap.putAll((Object)Boolean.TRUE, validDeployeds);
        deployedsMap.putAll((Object)Boolean.FALSE, invalidDeployeds);
        return deployedsMap;
    }

    private boolean isSimilar(Deployable newDeployable, Deployable deployable) {
        return newDeployable.getType().equals((Object)deployable.getType()) && newDeployable.getName().equals(deployable.getName());
    }

    private List<Deployed> generateDeployedsOfType(Collection<Deployable> deployables, Collection<Container> containers, Type deployedType, Dictionaries dictionaries) {
        return this.generateDeployedsOfType(deployables, containers, deployedType, dictionaries, false);
    }

    private List<Deployed> generateDeployedsOfType(Collection<Deployable> deployables, Collection<Container> containers, Type deployedType, Dictionaries dictionaries, boolean manualAction) {
        ArrayList deployeds = Lists.newArrayList();
        for (Deployable deployable : deployables) {
            for (Container container : containers) {
                Deployed<?, ?> deployed;
                ConsolidatedDictionary dictionary = dictionaries.filterBy(container).consolidate();
                if (deployedType != null) {
                    if (!this.typeCalculator.findDeployedTypesForDeployableAndContainerTypes(deployable.getType(), container.getType()).contains(deployedType)) continue;
                    deployeds.add(this.deployedGenerator.generateDeployed(deployable, container, deployedType, dictionary));
                    continue;
                }
                if (manualAction) {
                    logger.debug("Creating manual deployed for [{}] and [{}]", (Object)deployable, (Object)container);
                    deployed = this.deployedGenerator.createMostSpecificDeployed(deployable, container, dictionary);
                } else {
                    logger.debug("Creating automatic deployed for [{}] and [{}]", (Object)deployable, (Object)container);
                    deployed = this.deployedGenerator.autoGenerateMostSpecificDeployed(deployable, container, dictionary);
                }
                if (deployed == null) continue;
                deployeds.add(deployed);
            }
        }
        return deployeds;
    }

    private static class Key {
        private String deployableId;
        private String containerId;

        private Key(String deployableId, String containerId) {
            this.deployableId = deployableId;
            this.containerId = containerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.containerId.equals(key.containerId) && this.deployableId.equals(key.deployableId);
        }

        public int hashCode() {
            int result = this.deployableId.hashCode();
            result = 31 * result + this.containerId.hashCode();
            return result;
        }
    }

    private static class Value {
        private Deployed deployed;
        private boolean valid;

        private Value(Deployed deployed) {
            this.deployed = deployed;
        }

        Value valid() {
            this.valid = true;
            return this;
        }

        private boolean isValid() {
            return this.valid;
        }
    }

    private static class FilterSet {
        private Function<Deployed, Key> KEY_FUNC = new Function<Deployed, Key>(){

            public Key apply(Deployed input) {
                return new Key(input.getDeployable().getId(), input.getContainer().getId());
            }
        };
        private Map<Key, Value> map = Maps.newHashMap();

        public FilterSet(Collection<Deployed> initialDeployeds) {
            for (Deployed initialDeployed : initialDeployeds) {
                this.map.put((Key)this.KEY_FUNC.apply((Object)initialDeployed), new Value(initialDeployed));
            }
        }

        public void add(Deployed deployed) {
            Value v;
            Key k = (Key)this.KEY_FUNC.apply((Object)deployed);
            Value previous = this.map.put(k, v = new Value(deployed).valid());
            if (previous != null) {
                logger.debug("Filtering out [{}] because it is already present.", (Object)deployed);
                this.map.put(k, previous.valid());
            }
        }

        public List<Deployed> getAllValidAsList() {
            return FluentIterable.from(this.map.values()).filter((Predicate)new Predicate<Value>(){

                public boolean apply(Value input) {
                    return input.isValid();
                }
            }).transform((Function)new Function<Value, Deployed>(){

                public Deployed apply(Value input) {
                    return input.deployed;
                }
            }).toImmutableList();
        }
    }
}

