/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.ssh.SshConnection;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.ssh.SshScpFile;
import com.xebialabs.overthere.ssh.SshSudoConnection;
import com.xebialabs.overthere.ssh.SshSudoOutputStream;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.LoggingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereExecutionOutputHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SshSudoFile
extends SshScpFile {
    private boolean isTempFile;
    private Logger logger = LoggerFactory.getLogger(SshSudoFile.class);

    public SshSudoFile(SshSudoConnection connection, String remotePath, boolean isTempFile) {
        super(connection, remotePath);
        this.isTempFile = isTempFile;
    }

    @Override
    protected int executeCommand(OverthereExecutionOutputHandler outHandler, OverthereExecutionOutputHandler errHandler, CmdLine commandLine) {
        if (this.isTempFile) {
            commandLine = SshConnection.prefixWithPseudoCommand(commandLine, "nosudo");
        }
        return super.executeCommand(outHandler, errHandler, commandLine);
    }

    @Override
    public OverthereFile getFile(String name) {
        SshSudoFile f = (SshSudoFile)super.getFile(name);
        f.isTempFile = this.isTempFile;
        return f;
    }

    @Override
    public OverthereFile getParentFile() {
        SshSudoFile f = (SshSudoFile)super.getParentFile();
        f.isTempFile = this.isTempFile;
        return f;
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.getInputStream();
        }
        OverthereFile tempFile = ((SshScpConnection)this.connection).getTempFile(this.getName());
        this.copyToTempFile(tempFile);
        return tempFile.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws RuntimeIOException {
        if (this.isTempFile) {
            return super.getOutputStream();
        }
        this.logger.debug("Opening ssh:sudo: output stream to write to file {}", (Object)this);
        return new SshSudoOutputStream(this, ((SshScpConnection)this.connection).getTempFile(this.getName()));
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        if (this.isTempFile) {
            this.logger.debug("Creating world-writable directory, with sticky bit (mode 01777)");
            this.mkdir(this.getCommand("sudoTempMkdirCommand", "mkdir -m 1777 {0}"));
        } else {
            super.mkdir();
        }
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        if (this.isTempFile) {
            this.logger.debug("Creating world-writable directories, with sticky bit (mode 01777)");
            this.mkdir(this.getCommand("sudoTempMkdirsCommand", "mkdir -p -m 1777 {0}"));
        } else {
            super.mkdirs();
        }
    }

    @Override
    protected void copyFrom(OverthereFile source) {
        if (this.isTempFile) {
            super.copyFrom(source);
            this.overrideUmask(this);
        } else {
            this.logger.debug("Copying file or directory {} to {}", (Object)source, (Object)this);
            OverthereFile tempFile = ((SshScpConnection)this.getConnection()).getTempFile(this.getName());
            try {
                ((SshScpConnection)this.connection).getSshClient().newSCPFileTransfer().newSCPUploadClient().copy((LocalSourceFile)new SshScpFile.OverthereFileLocalSourceFile(source), tempFile.getPath());
            }
            catch (IOException e) {
                throw new RuntimeIOException("Cannot copy " + source + " to " + this, e);
            }
            this.overrideUmask(tempFile);
            this.copyFromTempFile(tempFile);
        }
    }

    private void overrideUmask(OverthereFile remoteFile) {
        boolean sudoOverrideUmask = ((SshSudoConnection)this.connection).sudoOverrideUmask;
        if (sudoOverrideUmask) {
            this.logger.debug("Overriding umask by recursively setting permissions on files and/or directories copied with scp to be readable and executable (if needed) by group and other");
            CmdLine chmodCmdLine = CmdLine.build("nosudo", "nocd").addTemplatedFragment(this.getCommand("sudoOverrideUmaskCommand", "chmod -R go+rX {0}"), remoteFile.getPath());
            CapturingOverthereExecutionOutputHandler capturedOutput = CapturingOverthereExecutionOutputHandler.capturingHandler();
            int errno = ((SshScpConnection)this.connection).execute(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(this.logger), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(this.logger), capturedOutput), chmodCmdLine);
            if (errno != 0) {
                throw new RuntimeIOException("Cannot set permissions on file " + this + " to go+rX: " + capturedOutput.getOutput() + " (errno=" + errno + ")");
            }
        }
    }

    void copyToTempFile(OverthereFile tempFile) {
        this.logger.debug("Copying actual file {} to temporary file {} before download", (Object)this, (Object)tempFile);
        boolean sudoPreserveAttributesOnCopyToTempFile = ((SshSudoConnection)this.connection).sudoPreserveAttributesOnCopyToTempFile;
        String defaultCommand = "cp -r {0} {1}";
        if (sudoPreserveAttributesOnCopyToTempFile) {
            defaultCommand = "cp -pr {0} {1}";
        }
        CmdLine cpCmdLine = CmdLine.build("nocd").addTemplatedFragment(this.getCommand("sudoCopyToTempFileCommand", defaultCommand), this.getPath(), tempFile.getPath());
        CapturingOverthereExecutionOutputHandler cpCapturedOutput = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int cpResult = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(this.logger), cpCapturedOutput), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(this.logger), cpCapturedOutput), cpCmdLine);
        if (cpResult != 0) {
            String errorMessage = cpCapturedOutput.getOutput();
            throw new RuntimeIOException("Cannot copy actual file " + this + " to temporary file " + tempFile + " before download: " + errorMessage);
        }
        CmdLine chmodCmdLine = CmdLine.build("nocd").addTemplatedFragment(this.getCommand("sudoOverrideUmaskCommand", "chmod -R go+rX {0}"), tempFile.getPath());
        CapturingOverthereExecutionOutputHandler chmodCapturedOutput = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int chmodResult = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(this.logger), chmodCapturedOutput), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(this.logger), chmodCapturedOutput), chmodCmdLine);
        if (chmodResult != 0) {
            String errorMessage = chmodCapturedOutput.getOutput();
            throw new RuntimeIOException("Cannot grant group and other read and execute permissions (chmod -R go+rX) to file " + tempFile + " before download: " + errorMessage);
        }
    }

    void copyFromTempFile(OverthereFile tempFile) {
        this.logger.debug("Copying temporary file {} to actual file {} after upload", (Object)tempFile, (Object)this);
        String targetPath = this.getPath();
        if (this.exists() && tempFile.isDirectory()) {
            targetPath = this.getParentFile().getPath();
        }
        CmdLine cpCmdLine = CmdLine.build("nocd");
        String defaultCommand = "cp -r {0} {1}";
        if (((SshSudoConnection)this.connection).sudoPreserveAttributesOnCopyFromTempFile) {
            defaultCommand = "cp -pr {0} {1}";
        }
        cpCmdLine.addTemplatedFragment(this.getCommand("sudoCopyFromTempFileCommand", defaultCommand), tempFile.getPath(), targetPath);
        CapturingOverthereExecutionOutputHandler cpCapturedOutput = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int cpResult = ((SshScpConnection)this.getConnection()).execute(MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(this.logger), cpCapturedOutput), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(this.logger), cpCapturedOutput), cpCmdLine);
        if (cpResult != 0) {
            String errorMessage = cpCapturedOutput.getOutput();
            throw new RuntimeIOException("Cannot copy temporary file " + tempFile + " to actual file " + this + " after upload: " + errorMessage);
        }
    }

    boolean isTempFile() {
        return this.isTempFile;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SshSudoFile)) {
            return false;
        }
        return super.equals(obj) && this.isTempFile == ((SshSudoFile)obj).isTempFile;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Boolean.valueOf(this.isTempFile).hashCode();
    }
}

