/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

@DefaultAnnotation(value={NonNull.class})
public abstract class IOExceptionSeekableByteChannel
extends DecoratingSeekableByteChannel {
    @CheckForNull
    protected IOException exception;

    protected IOExceptionSeekableByteChannel(@Nullable SeekableByteChannel channel) {
        super(channel);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        try {
            return this.delegate.read(dst);
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        try {
            return this.delegate.write(src);
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    @Override
    public long position() throws IOException {
        try {
            return this.delegate.position();
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        try {
            this.delegate.position(newPosition);
            return this;
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    @Override
    public long size() throws IOException {
        try {
            return this.delegate.size();
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        try {
            this.delegate.truncate(size);
            return this;
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        catch (IOException ex) {
            this.exception = ex;
            throw this.exception;
        }
    }
}

