from java.util import HashSet

def containers():
    result = HashSet()
    for _delta in deltas.deltas:
        deployed = _delta.deployedOrPrevious
        current_container = deployed.container
        if _delta.operation != "NOOP" and deployed.type == "xlrelease.DeployedPlugin":
            result.add(deployed.container)
    return result


for container in containers():
    context.addStep(steps.os_script(
        description="Stop %s" % container.name,
        order=19,
        script="xlrelease/stop-xlrelease",
        freemarker_context={'container': container},
        target_host=container.host
    ))
    context.addStep(steps.wait(
        description="Wait 7 seconds for XL Release to stop",
        seconds=7,
        order=20
    ))
    context.addStep(steps.os_script(
        description="Start %s" % container.name,
        order=80,
        script="xlrelease/start-xlrelease",
        freemarker_context={'container': container},
        target_host=container.host
    ))
    context.addStep(steps.wait(
        description="Wait 30 seconds for XL Release to stop",
        seconds=30,
        order=81
    ))
