/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.xlrelease;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.generic.ci.BaseGenericContainer;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.ci.NestedContainer;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.generic.step.WaitStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.deployit.plugin.xlrelease.RecreateDataContributor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ServerRestartContributor {
    @Contributor
    public void restartContainers(Deltas deltas, DeploymentPlanningContext plan) {
        for (BaseGenericContainer container : ServerRestartContributor.getStartableContainers(deltas.getDeltas())) {
            ServerRestartContributor.addStartSteps(plan, container);
        }
        for (BaseGenericContainer container : ServerRestartContributor.getStoppableContainers(deltas.getDeltas())) {
            ServerRestartContributor.addStopSteps(plan, container);
        }
    }

    private static void addStartSteps(DeploymentPlanningContext plan, BaseGenericContainer target) {
        Preconditions.checkArgument((!ServerRestartContributor.isNullOrEmpty(target.getStartScript()) ? 1 : 0) != 0, (Object)String.format("%s start script must be specified when no restart script defined.", target.getId()));
        plan.addStep(ServerRestartContributor.createScriptStep("Start", target, target.getStartScript(), target.getStartOrder(), target.getStartClasspathResources(), target.getStartTemplateClasspathResources()));
        ServerRestartContributor.addWaitStep(plan, "start", target, target.getStartWaitTime(), target.getStartOrder());
    }

    private static void addStopSteps(DeploymentPlanningContext plan, BaseGenericContainer target) {
        Preconditions.checkArgument((!ServerRestartContributor.isNullOrEmpty(target.getStopScript()) ? 1 : 0) != 0, (Object)String.format("%s stop script must be specified when no restart script defined.", target.getId()));
        plan.addStep(ServerRestartContributor.createScriptStep("Stop", target, target.getStopScript(), target.getStopOrder(), target.getStopClasspathResources(), target.getStopTemplateClasspathResources()));
        ServerRestartContributor.addWaitStep(plan, "stop", target, target.getStopWaitTime(), target.getStopOrder());
    }

    private static void addWaitStep(DeploymentPlanningContext plan, String action, BaseGenericContainer target, int waitTime, int scriptOrder) {
        if (waitTime > 0) {
            plan.addStep((Step)new WaitStep(scriptOrder + 1, waitTime, target.getName(), action));
        }
    }

    private static Step createScriptStep(String verb, BaseGenericContainer container, String script, int scriptOrder, Set<String> classpathResources, Set<String> templateClasspathResources) {
        HashMap vars = Maps.newHashMap();
        vars.put("container", container);
        ScriptExecutionStep step = new ScriptExecutionStep(scriptOrder, script, (HostContainer)container, (Map)vars, ServerRestartContributor.getDescription(verb, container));
        step.setClasspathResources((List)Lists.newArrayList(classpathResources));
        step.setTemplateClasspathResources((List)Lists.newArrayList(templateClasspathResources));
        return step;
    }

    private static String getDescription(String verb, BaseGenericContainer container) {
        return String.format("%s %s", verb, container.getName());
    }

    private static Set<BaseGenericContainer> getStartableContainers(List<Delta> operations) {
        TreeSet targets = Sets.newTreeSet();
        for (Delta operation : operations) {
            if (!ServerRestartContributor.shouldStartServer(operation)) continue;
            targets.add(ServerRestartContributor.getContainerToRestart(operation.getDeployed().getContainer()));
        }
        return targets;
    }

    private static Set<BaseGenericContainer> getStoppableContainers(List<Delta> operations) {
        TreeSet targets = Sets.newTreeSet();
        for (Delta operation : operations) {
            if (!ServerRestartContributor.shouldStopServer(operation)) continue;
            targets.add(ServerRestartContributor.getContainerToRestart(operation.getPrevious().getContainer()));
        }
        return targets;
    }

    private static BaseGenericContainer getContainerToRestart(com.xebialabs.deployit.plugin.api.udm.Container c) {
        if (c instanceof Container) {
            return (Container)c;
        }
        if (c instanceof NestedContainer) {
            NestedContainer nc = (NestedContainer)c;
            if (!(ServerRestartContributor.isNullOrEmpty(nc.getStartScript()) && ServerRestartContributor.isNullOrEmpty(nc.getStopScript()) && ServerRestartContributor.isNullOrEmpty(nc.getRestartScript()))) {
                return nc;
            }
            return ServerRestartContributor.getContainerToRestart((com.xebialabs.deployit.plugin.api.udm.Container)nc.getParentContainer());
        }
        throw new IllegalStateException(String.format("Container [%s] is not a generic (nested) container", c));
    }

    private static boolean shouldStartServer(Delta delta) {
        if (delta.getDeployed() == null) {
            return false;
        }
        return delta.getDeployed().getType().equals((Object)RecreateDataContributor.INSTALLATION) && (delta.getOperation() == Operation.CREATE || delta.getOperation() == Operation.MODIFY);
    }

    private static boolean shouldStopServer(Delta delta) {
        if (delta.getPrevious() == null) {
            return false;
        }
        return delta.getPrevious().getType().equals((Object)RecreateDataContributor.INSTALLATION) && (delta.getOperation() == Operation.DESTROY || delta.getOperation() == Operation.MODIFY);
    }

    private static boolean isNullOrEmpty(String s) {
        return Strings.nullToEmpty((String)s).trim().isEmpty();
    }
}

