/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.xlrelease;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.DefaultDelta;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.generic.deployed.ExecutedScript;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class RecreateDataContributor {
    static final Type INSTALLATION = Type.valueOf((String)"xlrelease.XLReleaseInstallation");
    private static final Set<Type> DATA_TYPES = Sets.newHashSet((Object[])new Type[]{Type.valueOf((String)"xlrelease.InstalledXLReleaseData"), Type.valueOf((String)"xlrelease.User")});

    @Contributor
    public static void insertDataOnReinstall(Deltas deltas, DeploymentPlanningContext plan) {
        for (Container container : RecreateDataContributor.affectedContainers(deltas)) {
            Boolean cleanRepositoryOnUpgrade = (Boolean)container.getProperty("cleanRepositoryOnUpgrade");
            if (!cleanRepositoryOnUpgrade.booleanValue()) continue;
            Set<Deployed<?, ?>> deployedData = RecreateDataContributor.getDeployedData(container, deltas, plan);
            RecreateDataContributor.recreateData(plan, deployedData);
        }
    }

    private static Set<Container> affectedContainers(Deltas deltas) {
        HashSet containers = Sets.newHashSet();
        for (Delta delta : deltas.getDeltas()) {
            if (!RecreateDataContributor.isServerInstallation(delta)) continue;
            containers.add(delta.getDeployed().getContainer());
        }
        return containers;
    }

    private static void recreateData(DeploymentPlanningContext plan, Set<Deployed<?, ?>> deployedData) {
        for (Deployed<?, ?> deployed : deployedData) {
            RecreateDataContributor.addCreateDataStep(deployed, plan);
        }
    }

    private static Set<Deployed<?, ?>> getDeployedData(Container container, Deltas deltas, DeploymentPlanningContext plan) {
        Set<Deployed<Deployed<?, ?>, Deployed<?, ?>>> deployedData = RecreateDataContributor.getDeployedDataInContainer(container, plan.getRepository());
        deployedData.removeAll(RecreateDataContributor.getRemovedData(deltas));
        return deployedData;
    }

    private static void addCreateDataStep(Deployed<?, ?> deployed, DeploymentPlanningContext plan) {
        ExecutedScript script = (ExecutedScript)deployed;
        DefaultDelta delta = new DefaultDelta(Operation.MODIFY, deployed, deployed);
        script.executeCreate(plan, (Delta)delta);
    }

    private static Set<Deployed<?, ?>> getDeployedDataInContainer(Container container, Repository repository) {
        LinkedHashSet data = Sets.newLinkedHashSet();
        for (Type type : DATA_TYPES) {
            List deployeds = repository.search(type, container.getId());
            data.addAll(deployeds);
        }
        return data;
    }

    private static Collection<Deployed<?, ?>> getRemovedData(Deltas deltas) {
        HashSet removed = Sets.newHashSet();
        for (Delta delta : deltas.getDeltas()) {
            if (!RecreateDataContributor.isDataRemoval(delta)) continue;
            removed.add(delta.getPrevious());
        }
        return removed;
    }

    private static boolean isServerInstallation(Delta delta) {
        if (delta.getDeployed() == null) {
            return false;
        }
        return delta.getDeployed().getType().equals((Object)INSTALLATION) && (delta.getOperation() == Operation.CREATE || delta.getOperation() == Operation.MODIFY);
    }

    private static boolean isDataRemoval(Delta delta) {
        if (delta.getPrevious() == null) {
            return false;
        }
        return DATA_TYPES.contains(delta.getPrevious().getType()) && delta.getOperation() == Operation.DESTROY;
    }
}

