XLRELEASE_HOME=${deployed.container.homeDir}
OLD_INSTALL_DIR=$XLRELEASE_HOME/current-version
NEW_TEMP_DIR=$XLRELEASE_HOME/new 
NEW_INSTALL_DIR=$NEW_TEMP_DIR/${deployed.deployitServerDir}
XLR_PACKAGE=${deployed.file}

echo OLD_INSTALL_DIR: $OLD_INSTALL_DIR
echo NEW_TEMP_DIR: $NEW_TEMP_DIR
echo NEW_INSTALL_DIR: $NEW_INSTALL_DIR
echo XLR_PACKAGE: $XLR_PACKAGE

cd $XLRELEASE_HOME

<#if deployed.container.backupOnUpgrade>
echo Backing up old version
mkdir -p backups
REAL_OLD_INSTALL_DIR=`readlink $OLD_INSTALL_DIR`
REAL_OLD_INSTALL_DIR=${r"${REAL_OLD_INSTALL_DIR%/}"} # Remove trailing slash
zip -qr backups/$REAL_OLD_INSTALL_DIR-backup.zip $REAL_OLD_INSTALL_DIR
</#if>

echo Installing new version
mkdir -p $NEW_TEMP_DIR
unzip -q $XLR_PACKAGE -d $NEW_TEMP_DIR
ln -s $XLRELEASE_HOME/xl-release-license.lic $NEW_INSTALL_DIR/conf/

<#if deployed.container.cleanRepositoryOnUpgrade>
echo Initializing XL Release version ${deployed.deployitServerDir}
sudo -u xl-release $NEW_INSTALL_DIR/bin/server.sh -setup -force -reinitialize -setup-defaults  ${step.remoteWorkingDirectory.path}/server.conf.defaults
<#else>
echo Upgrading XL Release
mv -f $OLD_INSTALL_DIR/conf/* $NEW_INSTALL_DIR/conf/
mv $OLD_INSTALL_DIR/repository $NEW_INSTALL_DIR/
mv -f $OLD_INSTALL_DIR/archive $NEW_INSTALL_DIR/ || true
mv -f $OLD_INSTALL_DIR/ext/* $NEW_INSTALL_DIR/ext/
mkdir -p $NEW_INSTALL_DIR/plugins
cp $OLD_INSTALL_DIR/plugins/* $NEW_INSTALL_DIR/plugins
</#if>

echo Removing old version
rm -rf $OLD_INSTALL_DIR/*

echo Putting new version in place
mv $NEW_INSTALL_DIR .
rm -rf $NEW_TEMP_DIR

echo Updating current version
rm current-version
ln -s ${deployed.deployitServerDir} current-version
