
<#assign workingDirectory='${deployed.container.workingDirectory}\\${deployed.name}'/>

<#assign apply_args='-input=false -no-color -auto-approve'/>

<#if deployed.parallelism??>
    <#assign apply_args='${apply_args} -parallelism=${deployed.parallelism}'/>
</#if>

<#if deployed.targets??>
    <#list deployed.targets as target>
        <#assign apply_args='${apply_args} -target=${target}'/>
    </#list>
</#if>

<#if deployed.inputVariables??>
    <#list deployed.inputVariables?keys as key>
        <#assign apply_args='${apply_args} -var ${key}=${deployed.inputVariables[key]}'/>
    </#list>
</#if>

<#assign apply_args_obfuscated="${apply_args}"/>

<#if deployed.secretInputVariables??>
    <#list deployed.secretInputVariables?keys as key>
        <#assign apply_args="${apply_args} -var ${key}=\"${deployed.secretInputVariables[key]?js_string}\""/>
        <#assign apply_args_obfuscated="${apply_args_obfuscated} -var ${key}=\"********\""/>
    </#list>
</#if>

<#assign terraform_apply="\"${deployed.container.path}\\terraform.exe\" apply" />
<#assign terraform_command='${terraform_apply} ${apply_args}' />
<#assign terraform_command_obfuscated='${terraform_apply} ${apply_args_obfuscated}' />

@echo off

echo "Changing working directory to ${workingDirectory}"
cd /d "${workingDirectory}"

echo "Executing ${terraform_command_obfuscated}"
${terraform_command}
