from com.xebialabs.deployit.plugin.api.reflect import Type
import re
import os
import json


class GenerateDeployables(object):
    def __init__(self, ci_id, vars):
        self.ci_id = ci_id
        self.repo = vars['repositoryService']
        self.path = self.repo.read(ci_id).file.path
        self.resource_descriptor = Type.valueOf(
            "terraform.Resource").descriptor

    def create_resource(self, resource):
        ci = self.resource_descriptor.newInstance(
            "%s/%s" % (self.ci_id, resource.name))
        ci.setProperty('content', resource.content)
        print "Creating CI: %s" % ci.id
        self.repo.create([ci])
        
    def get_name(self, line):
        matches = re.findall(r'\"(.+?)\"', line)
        return "-".join(matches)

    def process(self):
        for root, subdirs, files in os.walk(self.path):
            index = 1
            for filename in files:
                file_path = os.path.join(root, filename)
                if filename.endswith('.tf'):
                    self.processHCL(file_path)
                elif filename.endswith('.tf.json'):
                    self.processJSON(file_path)
                    
                    
    def processHCL(self, file_path):
        with open(file_path) as fp:
            line = fp.readline()
            reading_resource = False
            while line:
                if not reading_resource and line.lstrip().startswith("resource"):
                    resource = Resource(name=self.get_name(line))
                    resource.add_line(line)
                    reading_resource = True
                elif reading_resource:
                    resource.add_line(line)
                    if resource.closed_all_brackets():
                        self.create_resource(resource)
                        reading_resource = False
                line = fp.readline()
                
    def processJSON(self, file_path):
        with open(file_path) as fp:
            tf_json = json.loads(fp.read())
            for key, value in tf_json.items():
                if key == "resource":
                    for resource_type, resource_objects in value.items():
                        for name, resource_json in resource_objects.items():
                            resource = Resource(resource_type + "-" + name)
                            resource.content = json.dumps(resource_json, indent=2)
                            self.create_resource(resource)


class Resource(object):
    def __init__(self, name):
        self.content = ""
        self.brackets = 0
        self.name = name

    def add_line(self, line):
        self.content += line
        self.brackets += line.count("{")
        self.brackets -= line.count("}")

    def closed_all_brackets(self):
        return self.brackets == 0


GenerateDeployables(thisCi.id, locals()).process()
