import com.xebialabs.overthere.ConnectionOptions as ConnectionOptions
import com.xebialabs.overthere.Overthere as Overthere
import com.xebialabs.overthere.ConnectionOptions.JUMPSTATION as JUMPSTATION
import com.xebialabs.overthere.ConnectionOptions.TEMPORARY_DIRECTORY_PATH as TEMPORARY_DIRECTORY_PATH
import com.xebialabs.overthere.cifs.CifsConnectionBuilder.WINRS_PROXY_CONNECTION_OPTIONS as WINRS_PROXY_CONNECTION_OPTIONS
import com.xebialabs.overthere.cifs.CifsConnectionBuilder.WINRS_PROXY_PROTOCOL as WINRS_PROXY_PROTOCOL


class OverthereConnectionBuilder(object):

    __PROTOCOL = "protocol"
    __TEMPORARY_CI_DIRECTORY_PATH = "temporaryDirectoryPath"
    __CONNECTION_OPTIONS = "connectionOptions"
    __WINRS_PROXY = "winrsProxy"

    __jump_stations_seen = set()
    __winrs_proxies_seen = set()

    def get_connection(self, host):
        return Overthere.getConnection(host.getProperty(self.__PROTOCOL), self.get_connection_options(host))

    def get_connection_options(self, host):
        options = ConnectionOptions()
        self.copy_properties_to_connection_options(options, host)
        self.set_temporary_directory_path(options, host)
        return options

    def copy_properties_to_connection_options(self, options, host):
        for pd in host.getType().getDescriptor().getPropertyDescriptors():
            self.set_connection_option(options, pd.getName(), pd.get(host))

    def set_connection_option(self, options, key, value):
        if key == self.__PROTOCOL or key == self.__TEMPORARY_CI_DIRECTORY_PATH or key == self.__CONNECTION_OPTIONS:
            return

        if not value:
            return

        try:
            if int(value) == 0:
                return
        except:
            pass

        if key == JUMPSTATION:
            self.check_circular_reference(value, self.__jump_stations_seen, "jumpstations")
            jumpstation_options = ConnectionOptions()
            self.copy_properties_to_connection_options(jumpstation_options, value)
            options.set(JUMPSTATION, jumpstation_options)
        elif key == self.__WINRS_PROXY:
            self.check_circular_reference(value, self.__winrs_proxies_seen, "winrs proxies")
            options.set(WINRS_PROXY_PROTOCOL, value.getProperty(self.__PROTOCOL))
            winrs_proxy_options = ConnectionOptions()
            self.copy_properties_to_connection_options(winrs_proxy_options, value)
            options.set(WINRS_PROXY_CONNECTION_OPTIONS, winrs_proxy_options)
        else :
            options.set(key, value)

    def set_temporary_directory_path(self, options, host):
        temporary_directory_path = host.getProperty(self.__TEMPORARY_CI_DIRECTORY_PATH)
        if temporary_directory_path:
            self.set_connection_option(options, TEMPORARY_DIRECTORY_PATH, temporary_directory_path)

    @staticmethod
    def check_circular_reference(value, list, what):
        if value.id in list:
            raise RuntimeError("Detected loop in {}: {}".format(what, list))
        list.add(value.id)
