<#if previousDeployed.container.workingDirectory??>
    <#assign workingDirectory='${previousDeployed.container.workingDirectory}'/>
<#else>
    <#assign workingDirectory='${previousDeployed.container.path}'/>
</#if>

<#assign destroy_args='-force'/>

<#if previousDeployed.parallelism??>
    <#assign destroy_args='${destroy_args} -parallelism=${previousDeployed.parallelism}'/>
</#if>

<#if previousDeployed.targets??>
    <#list previousDeployed.targets as target>
        <#assign destroy_args='${destroy_args} -target=${target}'/>
    </#list>
</#if>

<#if previousDeployed.inputVariables??>
    <#list previousDeployed.inputVariables?keys as key>
        <#assign destroy_args='${destroy_args} -var ${key}=${previousDeployed.inputVariables[key]}'/>
    </#list>
</#if>

<#assign terraform_destroy="\"${previousDeployed.container.path}\\terraform.exe\" destroy ${destroy_args} \"${previousDeployed.file.path}\"" />
<#assign terraform_command='${terraform_destroy}' />

echo "Changing working directory to ${workingDirectory}"
cd "${workingDirectory}"

echo "Executing ${terraform_command}"
${terraform_command}
