<#if deployed.container.workingDirectory??>
    <#assign workingDirectory='${deployed.container.workingDirectory}'/>
<#else>
    <#assign workingDirectory='${deployed.container.path}'/>
</#if>

<#assign apply_args='-auto-approve'/>

<#if deployed.parallelism??>
    <#assign apply_args='${apply_args} -parallelism=${deployed.parallelism}'/>
</#if>

<#if deployed.targets??>
    <#list deployed.targets as target>
        <#assign apply_args='${apply_args} -target=${target}'/>
    </#list>
</#if>

<#if deployed.inputVariables??>
    <#list deployed.inputVariables?keys as key>
        <#assign apply_args='${apply_args} -var ${key}=${deployed.inputVariables[key]}'/>
    </#list>
</#if>

<#assign terraform_apply="\"${deployed.container.path}\\terraform.exe\" apply ${apply_args} \"${deployed.file.path}\"" />
<#assign terraform_command='${terraform_apply}' />

echo "Changing working directory to ${workingDirectory}"
cd "${workingDirectory}"

echo "Executing ${terraform_command}"
${terraform_command}
