from terraform.overthere_connection_builder import OverthereConnectionBuilder
import com.xebialabs.overthere.CmdLine as CmdLine
import com.xebialabs.deployit.plugin.terraform.CaptureOutputHandler as CaptureOutputHandler
import json

builder = OverthereConnectionBuilder()
connection = builder.get_connection(deployed.container.host._delegate)
working_directory = deployed.container.workingDirectory if deployed.container.workingDirectory else deployed.container.path

connection.setWorkingDirectory(connection.getFile(working_directory))
output_handler = CaptureOutputHandler()
command = CmdLine.build("{}{}terraform".format(deployed.container.path, deployed.container.host.os.fileSeparator), "output", "-json")
connection.execute(output_handler, None, command)

if output_handler.getOutput():
    output_variables = {}
    output_json = json.loads(output_handler.getOutput())

    for key in output_json:
        output_variables[key] = output_json[key]['value']
    deployed.outputVariables = output_variables
