
<#assign workingDirectory='${deployed.container.workingDirectory}\\${deployed.name}'/>

<#assign apply_args='-input=false -no-color -auto-approve'/>

<#if deployed.parallelism??>
    <#assign apply_args='${apply_args} -parallelism=${deployed.parallelism}'/>
</#if>

<#if deployed.targets??>
    <#list deployed.targets as target>
        <#assign apply_args='${apply_args} -target=${target}'/>
    </#list>
</#if>

<#if deployed.inputVariables??>
    <#list deployed.inputVariables?keys as key>
        <#assign apply_args='${apply_args} -var ${key}=${deployed.inputVariables[key]?j_string}'/>
    </#list>
</#if>

<#assign apply_args_obfuscated="${apply_args}"/>

<#if deployed.secretInputVariables??>
    <#list deployed.secretInputVariables?keys as key>
        <#assign apply_args="${apply_args} -var ${key}=\"${deployed.secretInputVariables[key]?j_string}\""/>
        <#assign apply_args_obfuscated="${apply_args_obfuscated} -var ${key}=\"********\""/>
    </#list>
</#if>

<#assign terraform_apply="\"${deployed.container.path}\\terraform.exe\" apply" />
<#assign terraform_command='${terraform_apply} ${apply_args}' />
<#assign terraform_command_obfuscated='${terraform_apply} ${apply_args_obfuscated}' />

@echo off
set TF_IN_AUTOMATION=true

echo "Changing working directory to ${workingDirectory}"
cd /d "${workingDirectory}"
echo "Executing ${terraform_command_obfuscated}"
${terraform_command}
IF %ERRORLEVEL% NEQ 0 exit /b 1


<#assign terraform_state_file="${deployed.container.workingDirectory}\\${deployed.name}\\terraform-remote.tfstate"/>
<#assign terraform_pull_state_command="\"${deployed.container.path}\\terraform.exe\" state pull > \"${terraform_state_file}\"" />
echo "Executing ${terraform_pull_state_command}"
${terraform_pull_state_command}
