#!/bin/bash

<#assign workingDirectory='${deployed.container.workingDirectory}/${deployed.name}'/>

<#assign init_args='-input=false -no-color'/>

<#if deployed.container.pluginDirectory??>
    <#assign init_args='-plugin-dir ${deployed.container.pluginDirectory}'/>
</#if>

<#if deployed.initParameters??>
    <#assign init_args='${init_args} ${deployed.initParameters}'/>
<#elseif deployed.container.initParameters??>
    <#assign init_args='${init_args} ${deployed.container.initParameters}'/>
</#if>

<#assign init_args_obfuscated="${init_args}"/>

<#if deployed.secretInitParameters??>
    <#assign init_args='${init_args} ${deployed.secretInitParameters}'/>
    <#assign init_args_obfuscated="${init_args_obfuscated} \"********\""/>
</#if>

<#if deployed.container.secretInitParameters??>
    <#assign init_args='${init_args} ${deployed.container.secretInitParameters}'/>
    <#assign init_args_obfuscated="${init_args_obfuscated} \"********\""/>
</#if>

<#assign terraform_init="'${deployed.container.path}/terraform' init ${init_args}" />
<#assign terraform_command='${terraform_init}' />

<#assign terraform_init_obfuscated="'${deployed.container.path}/terraform' init ${init_args_obfuscated}" />
<#assign terraform_command_obfuscated='${terraform_init_obfuscated}' />


export TF_IN_AUTOMATION=true

mkdir -p '${workingDirectory}'
echo "Changing working directory to ${workingDirectory}"
cd '${workingDirectory}'

echo "Cleaning up working directory and copying scripts from ${deployed.file.path}.."
<#if !deployed.container.deleteTerraformState??>
find . ! -name '*.tfstate' -delete
<#else>
find . -delete
</#if>
${deployed.container.cpCommand} '${deployed.file.path}/'* '${workingDirectory}'

echo "Executing ${terraform_command_obfuscated}"
${terraform_command}
