from terraform.planning_scripts.stitch_transformer import *

transformed_bytes = None
if deployed.container.enableStitch:
    print "***** Starting stitch transformation *****"
    transformed_bytes = StitchTransformer(context, deployed, stitch).transform()


if deployed.container.initParameters:
    deployed.initParameters = deployed.container.initParameters

context.addStep(steps.terraform_os_script(
    order=58,
    description="Initialize terraform module {}".format(deployed.name),
    script="terraform/terraform_init",
    freemarker_context={'transformed_bytes': transformed_bytes, 'deployedContainerInitParameters': deployed.initParameters},
))

context.addStepWithCheckpoint(steps.terraform_os_script(
    order=59,
    description="Apply terraform module {} with [{}] targets".format(deployed.name, ",".join(deployed.targets) if deployed.targets else 'all'),
    script="terraform/terraform_apply",
    preview_script="terraform/terraform_plan",
    freemarker_context={'transformed_bytes': transformed_bytes}
), delta)

context.addStep(steps.jython(
    order=60,
    description="Capture terraform output variables",
    script="terraform/capture_output_variables.py"
))