import os.path
from java.io import ByteArrayInputStream
from java.lang import Exception
from java.lang import String

import terraform.planning_scripts.file_utils as file_utils
import json

class StitchTransformer(object):
    def __init__(self, context, deployed, stitch):
        self.__context = context
        self.__deployed = deployed
        self.__stitch = stitch
        self.__file_src_for_stitch = deployed.file

    def transform(self):
        file_entries = file_utils.get_files_from_directory(self.__file_src_for_stitch, [])
        print("file contents as objects {}".format(file_entries))

        # apply stitch pre-processing

        for file_entry in file_entries:
            file_name = file_entry["file_name"]
            file_content = file_entry["file_content"]
            file_path = file_entry["file_path"]

            extension = os.path.splitext(file_name)[1][1:]
            if extension not in self.__deployed.excludeFileTypes:
                try:
                    base_path = self.__file_src_for_stitch.getPath()
                    invocation_name = "Transform {0} {1}".format(self.__deployed.name, file_path[file_path.startswith(base_path) and (len(base_path) + 1):])
                    transformation_context = {"format": extension, "invocationName": invocation_name}
                    transformed_content_stream = self.__stitch(ByteArrayInputStream(String(file_content).getBytes()), transformation_context)
                    stringified = file_utils.get_file_data(transformed_content_stream)
                    print('Template transformation applied for {}. Transformed content: {}'.format(file_name, stringified))
                    if extension == "tf":
                        try:
                             json.loads(stringified)
                             if os.path.exists(file_path):
                                 os.remove(file_path)
                             file_utils.write_to_file(file_path + ".json", stringified)
                        except ValueError:
                          print('Stitch transformation not applied saving the file as is {}'.format(file_path))
                    else:
                        file_utils.write_to_file(file_path, stringified)
                except Exception as e:
                    print("Planning script could not apply template transformation for {}. Reason: {}".format(file_name, e.getMessage()))
            else:
                file_utils.write_to_file(file_path, file_content)

        # apply stitch post-processing

        return file_utils.create_zip_from_dir_as_bytes(self.__file_src_for_stitch)
