import base64
from terraform.mapper.resource_mapper import ResourceMapper

class AKSClusterMapper(ResourceMapper):
    def __init__(self):
        super(AKSClusterMapper, self).__init__(["k8s.Master", "k8s.Namespace"])
        self.aks_attributes = {}

    def create_ci(self, tf_resource, folder):
        if self.types_supported(tf_resource['type']):
            if 'primary' in tf_resource:
                self.aks_attributes = tf_resource['primary']['attributes']
                cluster_name = self.aks_attributes['name']
                print("Creating CI of type 'k8s.Master' from '%s' cluster" % cluster_name)
                cluster_id = folder[:folder.rfind('/')+1] + cluster_name + "-AKSCluster"
                properties = {'isEKS':         False,
                              'skipTLS':       True,
                              'apiServerURL':  self.aks_attributes['kube_config.0.host'],
                              'token':         self.get_attribute('kube_config.0.password'),
                              'tlsCert' :      self.get_attribute('kube_config.0.client_certificate', True),
                              'tlsPrivateKey': self.get_attribute('kube_config.0.client_key', True)}
            else:
                self.aks_attributes = tf_resource['attributes']
                cluster_name = self.aks_attributes['name']
                print("Creating CI of type 'k8s.Master' from '%s' cluster" % cluster_name)
                cluster_id = folder[:folder.rfind('/')+1] + cluster_name + "-AKSCluster"
                properties = {'isEKS':         False,
                              'skipTLS':       True,
                              'apiServerURL':  self.get_kube_attribute('host'),
                              'token':         self.get_kube_attribute('password'),
                              'tlsCert' :      self.get_kube_attribute('client_certificate', True),
                              'tlsPrivateKey': self.get_kube_attribute('client_key', True)}
            return [
                super(AKSClusterMapper, self)._create_ci("k8s.Master", cluster_id, properties),
                self.create_namespace(cluster_id, "default")
            ]
        else:
            return None

    def create_namespace(self, cluster_id, name):
        namespace_id = "%s/%s" %(cluster_id, name)
        return super(AKSClusterMapper, self)._create_ci("k8s.Namespace", namespace_id, {'namespaceName': name})

    def get_attribute(self, key, b64decode=False):
        if key in self.aks_attributes:
            if b64decode:
                return base64.b64decode(self.aks_attributes[key])
            else:
                return self.aks_attributes[key]
        return None

    def get_kube_attribute(self, key, b64decode=False):
        try:
            if b64decode:
                return base64.b64decode(self.aks_attributes['kube_config'][0][key])
            else:
                return self.aks_attributes['kube_config'][0][key]
        except:
            return None