#!/bin/bash

<#assign workingDirectory='${deployed.container.workingDirectory}/${deployed.name}'/>


<#assign init_args='-input=false -no-color'/>

<#if deployed.container.pluginDirectory??>
    <#assign init_args='-plugin-dir ${deployed.container.pluginDirectory}'/>
</#if>

<#assign args='-input=false -no-color'/>

<#if deployed.parallelism??>
    <#assign args='${args} -parallelism=${deployed.parallelism}'/>
</#if>

<#if deployed.targets??>
    <#list deployed.targets as target>
        <#assign args='${args} -target=${target}'/>
    </#list>
</#if>

<#if deployed.inputVariables??>
    <#list deployed.inputVariables?keys as key>
        <#assign args="${args} -var ${key}=\"${deployed.inputVariables[key]?j_string}\""/>
    </#list>
</#if>

<#assign args_obfuscated="${args}"/>

<#if deployed.secretInputVariables??>
    <#list deployed.secretInputVariables?keys as key>
        <#assign args="${args} -var ${key}=\"${deployed.secretInputVariables[key]?j_string}\""/>
        <#assign args_obfuscated="${args_obfuscated} -var ${key}=\"********\""/>
    </#list>
</#if>

<#assign terraform_init="'${deployed.container.path}/terraform' init ${init_args}" />
<#assign terraform_plan="'${deployed.container.path}/terraform' plan -lock=false ${args}" />
export TF_IN_AUTOMATION=true

mkdir -p '${workingDirectory}'
cd '${workingDirectory}'

find . ! -name '*.tfstate' -delete
${deployed.container.cpCommand} '${deployed.file.path}/'* '${workingDirectory}'

${terraform_init} > /dev/null
${terraform_plan}
