<#assign workingDirectory='${deployed.container.workingDirectory}\\${deployed.name}'/>

<#assign init_args='-input=false -no-color'/>

<#if deployed.container.pluginDirectory??>
    <#assign init_args='-plugin-dir \"${deployed.container.pluginDirectory}\"'/>
</#if>

<#assign terraform_init="\"${deployed.container.path}\\terraform.exe\" init ${init_args}" />
<#assign terraform_command='${terraform_init}' />

@echo off
set TF_IN_AUTOMATION=true

mkdir "${workingDirectory}"
echo "Changing working directory to ${workingDirectory}"
cd /d "${workingDirectory}"

echo "Cleaning up working directory and copying scripts from ${deployed.file.path}.."
robocopy . temp_pit /XF *.tfstate /S /MOVE > NUL
rmdir temp_pit /S /Q
robocopy "${deployed.file.path}" "${workingDirectory}" /E

echo "Executing ${terraform_command}"
${terraform_command}
