import json
from com.xebialabs.overthere.util import OverthereUtils


def processElement(element):
    if type(element).__name__ == "str":
        element = element.lstrip('\'')
        element = element.rstrip('\'')
        element = element.replace('\"', '')

    return element


def capture_output(deployed):
    encoding = "UTF-8"
    connection = deployed.container.host._delegate.getConnection()
    state_file = "{}{}{}{}terraform.tfstate".format(deployed.container.workingDirectory, deployed.container.host.os.fileSeparator, deployed.name, deployed.container.host.os.fileSeparator)

    print("Read the state file {0}".format(state_file))

    otfile = connection.getFile(state_file)
    if not otfile.exists():
        raise Exception("File [%s] does not exist" % state_file)

    output = OverthereUtils.read(otfile, encoding)
    output_json = json.loads(output)
    if 'outputs' not in output_json:
        output_json = output_json['modules'][0]

    return output_json['outputs']


output_json = capture_output(deployed)

if len(output_json) > 0:
    output_variables = {}
    for key in output_json:
        output_variables[key] = processElement(json.dumps(output_json[key]['value']))
        print('%s = %s' % (key, output_variables[key]))
    deployed.outputVariables = output_variables
    context.logOutput("Output variables from Terraform captured.")
else:
    context.logOutput("No output variables found.")
