#
# Copyright (c) 2021. All rights reserved.
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import terraxld.api
reload(terraxld.api)
from terraxld.api import TFE

myapi = TFE(organization)
ws_id = myapi.workspaces.get_id(workspace)

basics=dict()
basics['TF_CLI_ARGS']='-no-color'
basics['CONFIRM_DESTROY']='1'

non_secured_items = {}
non_secured_items.update(basics)
non_secured_items.update(provider.variables)

secured_items = {}
secured_items.update(provider.credentials)

for cpm_key in provider.credentialsPropertyMapping:
    if cpm_key == "empty":
        continue
    key = provider.credentialsPropertyMapping[cpm_key]
    value = provider.getProperty(cpm_key)
    pd_key = provider.type.getDescriptor().getPropertyDescriptor(cpm_key)
    if pd_key.isPassword():
        secured_items[key]=value
    else:
        non_secured_items[key]=value


myapi.load_variables_in_workspace(non_secured_items, workspace, False, scope='env')
myapi.load_variables_in_workspace(secured_items, workspace, True, scope='env')

