#
# Copyright (c) 2021. All rights reserved.
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from terraxld.api import TFE
import re
import sys
import json


def dump_json(data, message):
    if True:
        print(50 * '=')
        print(message)
        print(50 * '=')
        json.dump(data, sys.stdout, indent=4)
        print(50 * '=')


def is_sensitive_variable(entry):
    return 'sensitive' in entry and entry['sensitive']


def add_value(entry, output_key_var, output_variables, secret_output_variables):
    if is_sensitive_variable(entry):
        print("   add {0}={1}".format(output_key_var, '******************'))
        secret_output_variables[output_key_var] = entry['value']
    else:
        print("   add {0}={1}".format(output_key_var, entry['value']))
        output_variables[output_key_var] = entry['value']


myapi = TFE(organization)
ws_id = myapi.workspaces.get_id(workspace)
output = myapi.state_versions.get_current_state_content_workspace(ws_id)
# dump_json(output, "OUTPUT")

if output:
    output_variables = {}
    secret_output_variables = {}
    output_json = output['outputs']

    for key in output_json:
        var_type = output_json[key]['type']
        print("{0}:{1}/{2}".format(key, var_type, type(var_type)))
        if isinstance(var_type, list):
            for num, value in enumerate(output_json[key]['value']):
                idx_key = "{0}_{1}".format(key, num)
                print("   add {0}={1}".format(idx_key, value))
                output_variables[idx_key] = value
        else:
            add_value(output_json[key], key, output_variables, secret_output_variables)
            # print("new output variable found {0}:{1}".format(key, output_variables[key]))
            expression_reg_exp = re.compile("([a-zA-Z_1-9]*)-([a-zA-Z_1-9]*)")
            mo = expression_reg_exp.findall(key)
            if len(mo) == 1:
                module = mo[0][0]
                output_var = mo[0][1]
                print("{0} => {1}".format(module, output_var))
                instantiated_module = [ci for ci in deployed.modules if ci.id.endswith(module)][0]
                print("instantiated module {0}".format(instantiated_module))
                if deployed.removeModulePrefixNameInDictionary:
                    add_value(output_json[key], output_var, output_variables, secret_output_variables)
                if instantiated_module.hasProperty(output_var):
                    instantiated_module.setProperty(output_var, output_json[key]['value'])
                else:
                    print("{0} hasn't {1} property, can't assign the value to the CI".format(instantiated_module, output_var))

    deployed.outputVariables = output_variables
    deployed.secretOutputVariables = secret_output_variables
    context.logOutput("Output variables from Terraform captured.")

    context.logOutput("---- outputVariables -----")
    for k, v in sorted(deployed.outputVariables.items()):
        print("-> {0}={1}".format(k, v))
    context.logOutput("---- /outputVariables -----")

    context.logOutput("---- secretOutputVariables -----")
    for k, v in sorted(deployed.secretOutputVariables.items()):
        print("-> {0}={1}".format(k, '******'))
    context.logOutput("---- /secretOutputVariables -----")

else:
    context.logOutput("No output variables found.")
