export default {
    addRuleButton: 'Add rule',
    cancelButton: 'Cancel',
    cancelDryRunMessage: 'Are you sure you want to leave? Your changes will be lost.',
    cancelDryRunTitle: 'Leave Dry Run',
    confirmDeleteChangeSetMessage: 'Are you sure you want to delete git branch?',
    confirmDeleteChangeSetTitle: 'Delete branch?',
    confirmLeaveSaveTitle: 'Leave without saving?',
    confirmPublishChangeSetMessage: 'Publishing the branch will merge it to' +
        ' the master branch. All published rules will be used in future deployments.' +
        ' Are you sure you want to publish the branch?',
    confirmPublishChangeSetTitle: 'Publish branch?',
    deleteBranchLabel: 'Delete',
    deleteBranchOnPublish: 'Delete branch "<%= branch %>" after publish.',
    deleteLabel: 'Delete',
    deploymentPropertiesButton: 'Deployment Properties',
    dryReRunLabel: 'Re-run',
    dryRunLabel: 'Dry run',
    editLabel: 'Edit',
    editRuleButton: 'Edit rule',
    errorTitle: 'Error',
    invalidCharactersLabel: 'Please enter only valid characters for the Name (no `/`, `\\`, `:`, `[`, `]`, `|`, `,` or `*`)', // eslint-disable-line max-len
    leaveAction: 'Leave',
    namespaces: {
        filterPlaceholder: 'Search namespaces...',
        noData: 'No namespaces',
        title: 'Namespaces (<%= total %>)'
    },
    noButton: 'No',
    noFileLeadingOrTrailingSpaces: (fileName) =>
        `The File name [${fileName}] must not contain leading or trailing spaces`,
    noLeadingOrTrailingSpaces: (ciName) => `The CI name [${ciName}] must not contain leading or trailing spaces`,
    noLeadingSlashValidator: (fileName) => `The File name [${fileName}] must not start with '/'`,
    publishButton: 'Publish',
    refreshButton: 'Refresh',
    requiredPermission: 'Required permission',
    saveButton: 'Save',
    sources: {
        filterPlaceholder: 'Search sources...',
        noData: 'No sources',
        title: 'Sources (<%= total %>)'
    },
    stayOnPageButton: 'Stay on the page',
    stitchChangeSets: {
        changeSetDeleted: 'Branch successfully deleted',
        changeSetDescription: 'created on <%= creationDate %> by <%= author %>',
        detailList: {branch: 'Branch'},
        filterPlaceholder: 'Filter branches...',
        header: {
            branch: 'Branch',
            sync: 'Sync'
        },
        noData: 'No branches',
        publish: {
            noRules: 'Branch <%= branchName %> for source <%= sourceId %> does not contain any rules',
            title: '<%= sourceId %>/<%= branchName %>'
        },
        title: 'Branches (<%= total %>)'
    },
    stitchLinkedFile: 'Linked file',
    stitchMacros: {
        detailList: {
            commitHash: 'Commit hash',
            commitUser: 'Commit userid',
            contentPath: 'File name',
            externalFiles: 'Linked files',
            lastSync: 'Last time synchronized',
            source: 'Source name'
        },
        filterPlaceholder: 'Filter macros...',
        header: {
            name: 'Macro name',
            sourceName: 'Source name',
            sync: 'Last time synchronized'
        },
        noData: 'No macros',
        title: 'Macros (<%= totalCount %>)'
    },
    stitchNoContent: 'No content to file for this item',
    stitchRules: {
        detailList: {
            commitHash: 'Commit hash',
            commitUser: 'Commit userid',
            contentPath: 'File name',
            externalFiles: 'Linked files',
            lastSync: 'Last time synchronized',
            source: 'Source name'
        },
        filterPlaceholder: 'Filter rules...',
        header: {
            name: 'Rule name',
            sourceName: 'Source name',
            sync: 'Last time synchronized'
        },
        newRuleFile: {
            branchAdd: 'Add new',
            branchDescription: 'Choose branch or create a new one',
            branchLabel: 'Branch',
            buttonTitle: 'New rule file',
            errorModal: {
                discard: 'Discard changes',
                ok: 'Ok',
                title: 'Error occurred while saving rule'
            },
            fileNameDescription: 'File where to store rule',
            fileNameLabel: 'File Name',
            fileNamePlaceholder: 'folder/stitch-rules-*.yaml',
            fileSavedToastrMessage: (fileName) => `File ${fileName} successfully saved`,
            repoDescription: (prop) => `Choose repository from the list (Property: ${prop})`,
            repoLabel: 'Repository',
            ruleName: 'New Rule'
        },
        noData: 'No rules',
        title: 'Rules (<%= total %>)'
    },
    stitchSource: {
        addGitSourceBtn: 'Add Git source',
        addSourceTitle: 'New source',
        classpathTitle: 'Classpath source',
        connectionSuccess: 'Connection successful',
        createToastrMessage: 'Source successfully created',
        deleteButton: 'Delete repository',
        deleteMessage: 'Are you sure you want to remove <%= name %> from <%= typeTitle %> list?',
        deleteTitle: 'Delete <%= typeTitle %>',
        deleteToastrMessage: 'Source successfully deleted',
        editSourceTitle: 'Edit source',
        folderDescription: 'Select an existing folder where the source should be placed.',
        folderSourceTitle: 'Folder sources',
        folderTitle: 'Folder',
        gitTitle: 'Git sources',
        idFieldDescription: 'ID of the source',
        idFieldName: 'ID',
        moveSource: 'Move source',
        moveSourceConfirm: 'Are you sure you want to move <%= sourceCiName %> to <%= targetCiId %>?',
        moveSourceTitle: 'Move <%= typeTitle %>',
        nameFieldDescription: 'The name of the source',
        nameFieldName: 'Name',
        noSources: 'No sources',
        state: {
            complete: 'Complete',
            failure: 'Failure',
            notSynchronized: 'Pending',
            synchronizing: 'Synchronizing'
        },
        syncAllSourceBtn: 'Sync all',
        syncChangeSetToastrMsg: 'Branch synchronization will take place in the background and ' +
        'updates will not be visible until the page is refreshed.',
        syncSourceToastrMsg: 'Source synchronization will take place in the background and ' +
            'updates will not be visible until the page is refreshed.',
        syncSourceToastrTitle: 'Synchronization',
        updateToastrMessage: 'Source successfully updated',
        zipTitle: 'Zip source'
    },
    successTitle: 'Success',
    syncNow: 'Sync now',
    tabNames: {
        branches: 'Branches',
        macros: 'Macros',
        rules: 'Rules',
        source: 'Sources'
    },
    testButton: 'Test',
    unsavedChangesNotification: 'If you leave now, all unsaved changes will be lost.',
    userProfileMissing: 'Set git credentials in User Profile settings to enable this operation',
    viewLogBtn: 'View log',
    yesButton: 'Yes'
};
