/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.puppet.upgrade;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CITypeUpgrader
extends JcrUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(CITypeUpgrader.class);
    private static final String PUPPET_PATH_PROPERTY = "puppetPath";
    public static final String MEMBERS = "members";
    public static final String ENVIRONMENT_CI_TYPE = "udm.Environment";

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting Puppet CI type upgrades ***");
        Map<String, String> renamedCis = this.getRenamedCis();
        renamedCis.entrySet().stream().forEach(entry -> repository.renameType((String)entry.getKey(), (String)entry.getValue()));
        Session session = ((RawRepositoryImpl)repository).getSession();
        Map<String, Node> puppetParents = this.updateContainers(repository, session);
        this.updateEnvironments(repository, session, puppetParents);
        this.removePuppetStandaloneNodes(repository, session);
        logger.info("*** Puppet CI type upgrades done ***");
        return true;
    }

    private void removePuppetStandaloneNodes(RawRepository repository, Session session) {
        List standaloneNodes = repository.findNodesByType(Type.valueOf((String)"puppet.Standalone"));
        for (Node node : standaloneNodes) {
            try {
                session.removeItem(node.getPath());
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<String, Node> updateContainers(RawRepository repository, Session session) {
        List standaloneNodes = repository.findNodesByType(Type.valueOf((String)"puppet.Standalone"));
        HashMap<String, Node> puppetParents = new HashMap<String, Node>();
        Iterator itr = standaloneNodes.iterator();
        while (itr.hasNext()) {
            try {
                Node node = (Node)itr.next();
                Node overthereSSHHostNode = node.getParent();
                puppetParents.put(node.getIdentifier(), overthereSSHHostNode);
                if (node.hasProperty(PUPPET_PATH_PROPERTY) && node.getProperty(PUPPET_PATH_PROPERTY) != null) {
                    overthereSSHHostNode.setProperty(PUPPET_PATH_PROPERTY, node.getProperty(PUPPET_PATH_PROPERTY).getValue());
                }
                NodeIterator childNodes = node.getNodes();
                while (childNodes.hasNext()) {
                    Node nextNode = childNodes.nextNode();
                    session.move(nextNode.getPath(), overthereSSHHostNode.getPath() + "/" + nextNode.getName());
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
        return puppetParents;
    }

    private void updateEnvironments(RawRepository repository, Session session, Map<String, Node> puppetParents) {
        List environments = repository.findNodesByType(Type.valueOf((String)ENVIRONMENT_CI_TYPE));
        for (Node environment : environments) {
            try {
                Value[] members = environment.getProperty(MEMBERS).getValues();
                for (int i = 0; i < members.length; ++i) {
                    if (puppetParents.get(members[i].getString()) == null) continue;
                    members[i] = session.getValueFactory().createValue(puppetParents.get(members[i].getString()));
                }
                environment.setProperty(MEMBERS, members);
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<String, String> getRenamedCis() {
        LinkedHashMap<String, String> cis = new LinkedHashMap<String, String>();
        cis.put("puppet.Manifest", "puppet.AppliedManifest");
        cis.put("puppet.ManifestSpec", "puppet.Manifest");
        cis.put("puppet.ManifestFolder", "puppet.AppliedManifestFolder");
        cis.put("puppet.ManifestFolderSpec", "puppet.ManifestFolder");
        cis.put("puppet.Module", "puppet.InstalledModule");
        cis.put("puppet.ModuleSpec", "puppet.Module");
        cis.put("puppet.TarBallModule", "puppet.InstalledTarBallModule");
        cis.put("puppet.TarBallModuleSpec", "puppet.TarBallModule");
        cis.put("puppet.provisioner.Module", "puppet.provisioner.InstalledModule");
        cis.put("puppet.provisioner.ModuleSpec", "puppet.provisioner.Module");
        cis.put("puppet.provisioner.AppliedTarBallModule", "puppet.provisioner.InstalledTarBallModule");
        return cis;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xld-puppet-plugin", (String)"6.0.0");
    }
}

