package com.xebialabs.xldeploy.provisioner

import com.xebialabs.deployit.engine.api.execution.{StepState, TaskPreviewBlock}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

sealed trait ErrorAware

sealed trait UnresolvedPlaceholders extends ErrorAware {
  val unresolvedPlaceholders: Option[Set[String]]
}

sealed trait ValidationErrors extends ErrorAware {
  val validationErrors: Option[Seq[ValidationError]]
}

sealed trait ProvisionedBlueprintAware {
  val provisionedBlueprint: ProvisionedBlueprint
}

case class ProvisioningRequest(packageId: String, provisioningEnvironmentId: String, placeholders: Option[Map[String, String]]) {
  def somePlaceholders = placeholders.getOrElse(Map())
}

case class DeprovisioningRequest(provisionedBlueprintId: String)

case class Provision(provisionedBlueprint: ProvisionedBlueprint,
                     provisioneds: Option[Seq[ConfigurationItem]] = None,
                     validationErrors: Option[Seq[ValidationError]] = None
                    ) extends ValidationErrors with ProvisionedBlueprintAware

case class ValidationError(reference: String, propertyName: Option[String], message: String)

case class ProvisioningTask(id: Option[String] = None, validationErrors: Option[Seq[ValidationError]] = None) extends ValidationErrors

case class TaskPreview(preview: Option[TaskPreviewBlock] = None, validationErrors: Option[Seq[ValidationError]] = None) extends ValidationErrors

case class StepPreview(preview: Option[StepState] = None, validationErrors: Option[Seq[ValidationError]] = None) extends ValidationErrors

case class SelectedProvision(selectedProvisionableIds: List[String], provision: Provision)