/**
  * Copyright © 2014-2016 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
  */
package com.xebialabs.xldeploy.provisioner

import com.xebialabs.deployit.plugin.api.udm._
import com.xebialabs.deployit.plugin.api.xld.{Distribution, DistributionVersion}
import com.xebialabs.xlplatform.documentation.PublicApiRef

import scala.beans.BeanProperty

@PublicApiRef
@SuppressWarnings(Array("serial"))
@Metadata(description = "A provisioning package contains provisionables and templates that, when mapped to a provisioning environment, will create CIs in the infrastructure.")
@TypeIcon("icons/types/upm.ProvisioningPackage.svg")
class ProvisioningPackage extends DistributionVersion {

  @BeanProperty
  @Property(description = "The environment name of the to be provisioned environment", required = false)
  var environmentName: String = null

  @BeanProperty
  @Property(description = "The directory path where the provisioned environment and provisioned configuration items will be stored.", required = false)
  var directoryPath: String = null

  @Property(description = "The set of provisionables that are part of this package.", asContainment = true, required = false)
  var provisionables: JSet[Provisionable] = new JHashSet[Provisionable]()

  @Property(description = "The set of CI templates.", asContainment = true, required = false)
  var templates: JSet[Template] = new JHashSet[Template]

  @Property(description = "The set of CI bound templates.", required = false, candidateValuesFilter = "filterBySelf")
  var boundTemplates: JSet[Template] = new JHashSet[Template]()

  @Property(description = "The blueprint to which this provisioning package belongs.", asContainment = true)
  @BeanProperty
  var blueprint: Blueprint = null

  override def getDistribution: Distribution = blueprint

  override def getDeployables: JSet[Deployable] = new JHashSet[Deployable](provisionables)

  override def setDistribution(distribution: Distribution): Unit = {
    blueprint = distribution.asInstanceOf[Blueprint]
  }
}
