package com.xebialabs.xldeploy.provisioner

import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot._
import com.xebialabs.deployit.plugin.api.udm._
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem

@Metadata(description = "Base type for an embedded provisioned.", virtual = true, inspectable = false, root = NESTED)
@TypeIcon("icons/types/upm.Provisioned.svg")
class BaseEmbeddedProvisioned[D <: EmbeddedDeployable, C <: EmbeddedDeployedContainer[_ <: ConfigurationItem, _ <: ConfigurationItem]] extends BaseConfigurationItem with EmbeddedDeployed[D, C] {

  @Property(required = false, description = "The provisionable from which this provisioned is derived.")
  @DeployedSpecific
  private var provisionable: D = _

  @Property(asContainment = true, description = "The provider on which this provisioned runs.")
  @DeployedSpecific
  private var provisioned: C = _

  override def setContainer(container: C): Unit = provisioned = container

  override def getContainer: C = provisioned

  override def setDeployable(deployable: D): Unit = provisionable = deployable

  override def getDeployable: D = provisionable
}
