/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.provisioner;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.services.SearchParameters;
import com.xebialabs.deployit.plugin.api.udm.CandidateValuesFilter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;
import com.xebialabs.deployit.plugin.api.xld.DistributionVersion;
import com.xebialabs.deployit.plugin.api.xld.Domain;
import com.xebialabs.xldeploy.provisioner.ProvisioningEnvironment;
import com.xebialabs.xldeploy.provisioner.ProvisioningPackage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Metadata(description="A provisioned blueprint of a provisioning package to a provisioning environment.")
@TypeIcon(value="icons/types/upm.ProvisionedBlueprint.svg")
public class ProvisionedBlueprint
extends AppliedDistribution {
    @Property(description="The package that was provisioned to the provisioning environment.", candidateValuesFilter="findProvisioningPackage")
    private ProvisioningPackage provisioningPackage;
    @Property(asContainment=true)
    private ProvisioningEnvironment provisioningEnvironment;
    @Property(description="The provisioned items that were provisioned to the provisioning environment.")
    private Set<Deployed> provisioneds = new HashSet<Deployed>();
    @Property(description="The environment that was provisioned.", required=false, asContainment=false, category="Provisioning")
    private Environment provisionedEnvironment;
    @Property(description="Resolved configuration items from templates on provisioning package", required=false, asContainment=false, category="Provisioning")
    private Set<ConfigurationItem> boundConfigurationItems;
    @Property(description="Placeholders provided by the user at provisioning.", required=false)
    private Map<String, String> unresolvedPlaceholders = new HashMap<String, String>();
    @Property(description="The id generated for by XLD to distinguish this provisioning", required=true, category="Provisioning")
    private String provisioningId;
    @Property(description="The environment name of the the to be provisioned environment", required=true, category="Provisioning")
    private String environmentName;
    @Property(description="The directory path where the provisioned environment and provisioned configuration items will be stored.", required=false, category="Provisioning")
    private String directoryPath;

    public DistributionVersion getVersion() {
        return this.provisioningPackage;
    }

    public void setVersion(DistributionVersion version) {
        this.provisioningPackage = (ProvisioningPackage)version;
    }

    public Domain getEnvironment() {
        return this.provisioningEnvironment;
    }

    public void setEnvironment(Domain Domain2) {
        this.provisioningEnvironment = (ProvisioningEnvironment)Domain2;
    }

    public Set<Deployed> getDeployeds() {
        return this.provisioneds;
    }

    public void addDeployed(Deployed deployed) {
        this.provisioneds.add(deployed);
    }

    public ProvisioningPackage getProvisioningPackage() {
        return this.provisioningPackage;
    }

    public ProvisioningEnvironment getProvisioningEnvironment() {
        return this.provisioningEnvironment;
    }

    public Map<String, String> getUnresolvedPlaceholders() {
        return this.unresolvedPlaceholders;
    }

    public Map<String, String> getUnresolvedPlaceholdersWithValues() {
        return this.getUnresolvedPlaceholders().entrySet().stream().filter(e -> !((String)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void setProvisioningPackage(ProvisioningPackage provisioningPackage) {
        this.provisioningPackage = provisioningPackage;
    }

    public void setProvisioningEnvironment(ProvisioningEnvironment provisioningEnvironment) {
        this.provisioningEnvironment = provisioningEnvironment;
    }

    public void setProvisionedEnvironment(Environment environment) {
        this.provisionedEnvironment = environment;
    }

    public Environment getProvisionedEnvironment() {
        return this.provisionedEnvironment;
    }

    public void setUnresolvedPlaceholders(Map<String, String> unresolvedPlaceholders) {
        this.unresolvedPlaceholders = unresolvedPlaceholders;
    }

    public void setDeployeds(Set<Deployed> deployeds) {
        this.provisioneds = deployeds;
    }

    public void addDeployeds(Collection<Deployed> deployeds) {
        this.provisioneds.addAll(deployeds);
    }

    public Set<ConfigurationItem> getBoundConfigurationItems() {
        return this.boundConfigurationItems;
    }

    public void setBoundConfigurationItems(Set<ConfigurationItem> boundConfigurationItems) {
        this.boundConfigurationItems = boundConfigurationItems;
    }

    public void setProvisioningId(String provisioningId) {
        this.provisioningId = provisioningId;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public String getProvisioningId() {
        return this.provisioningId;
    }

    @CandidateValuesFilter(name="findProvisioningPackage")
    public static SearchParameters findProvisioningPackage(ConfigurationItem context, PropertyDescriptor property) {
        ProvisionedBlueprint da = (ProvisionedBlueprint)context;
        SearchParameters params = new SearchParameters();
        params.setType(property.getReferencedType());
        ProvisioningPackage provisioningPackage = da.getProvisioningPackage();
        if (provisioningPackage != null) {
            params.setParent(provisioningPackage.getBlueprint().getId());
        }
        return params;
    }
}

