<#assign volumeName = deployed.volumeName?default(deployed.name)>
<#assign labels = deployed.labels?if_exists>
<#assign driverOptions = deployed.driverOptions?if_exists>
<#assign driver = deployed.driver?if_exists>
<#assign additionalFlags = deployed.additionalFlags?if_exists>

<#assign podmanVolumeCreateCommand="podman volume create">

<#if driver?length gt 0>
  <#assign podmanVolumeCreateCommand += " --driver ${driver}">
</#if>

<#if labels?size gt 0>
  <#list labels as key, value>
    <#assign podmanVolumeCreateCommand += " --label ${key}=${value}">
  </#list>
</#if>

<#if driverOptions?size gt 0>
  <#list driverOptions as key, value>
    <#assign podmanVolumeCreateCommand += " --opt ${key}=${value}">
  </#list>
</#if>

<#if additionalFlags?length gt 0> <#assign podmanVolumeCreateCommand += " ${additionalFlags}"> </#if>
<#assign podmanVolumeCreateCommand += " ${volumeName}">

echo "Creating volume ${volumeName}"
${podmanVolumeCreateCommand}
if [ $? -ne 0 ]; then
    exit 1
fi
