<#assign secretName = deployed.secretName?default(deployed.name)>
<#assign labels = deployed.labels?if_exists>
<#assign driver = deployed.driver>
<#assign additionalFlags = deployed.additionalFlags?if_exists>

<#if deployed.secret?length gt 0>
  <#assign secret = deployed.secret>
</#if>

<#assign podmanSecretCreateCommand="podman secret create ${secretName} --driver ${driver} ${secret}">

<#if labels?size gt 0>
  <#list labels as key, value>
    <#assign podmanSecretCreateCommand += " --label ${key}=${value}">
  </#list>
</#if>

<#if additionalFlags?length gt 0> <#assign podmanSecretCreateCommand += " ${additionalFlags}"> </#if>

echo "Creating secret ${secretName}"
${podmanSecretCreateCommand}
IF %ERRORLEVEL% NEQ 0 exit /b 1
