<#assign networkName = deployed.networkName?default(deployed.name)>
<#assign labels = deployed.labels?if_exists>
<#assign driver = deployed.driver?if_exists>
<#assign ipv6Enabled = deployed.ipv6Enabled>
<#assign ignore = deployed.ignore>
<#assign internal = deployed.internal>
<#assign options = deployed.options?if_exists>
<#assign ipamDriver = deployed.ipamDriver?if_exists>
<#assign configBindings = deployed.configBindings?if_exists>
<#assign additionalFlags = deployed.additionalFlags?if_exists>

<#assign podmanNetworkCreateCommand="podman network create">

<#if ignore>
   <#assign podmanNetworkCreateCommand += " --ignore">
</#if>

<#if internal>
  <#assign podmanNetworkCreateCommand += " --internal">
</#if>

<#if ipv6Enabled>
  <#assign podmanNetworkCreateCommand += " --ipv6">
</#if>

<#if driver?length gt 0>
  <#assign podmanNetworkCreateCommand += " --driver ${driver}">
</#if>

<#if ipamDriver?length gt 0>
  <#assign podmanNetworkCreateCommand += " --ipam-driver ${ipamDriver}">
</#if>

<#if configBindings?size gt 0>
  <#list configBindings as config>
     <#if config.subnet?has_content && config.subnet?length gt 0>
         <#assign podmanNetworkCreateCommand += " --subnet ${config.subnet}">
     </#if>

     <#if config.gateway?has_content && config.gateway?length gt 0>
        <#assign podmanNetworkCreateCommand += " --gateway ${config.gateway}">
     </#if>

     <#if config.ipRange?has_content && config.ipRange?length gt 0>
        <#assign podmanNetworkCreateCommand += " --ip-range ${config.ipRange}">
     </#if>
  </#list>
</#if>

<#if labels?size gt 0>
  <#list labels as key, value>
    <#assign podmanNetworkCreateCommand += " --label ${key}=${value}">
  </#list>
</#if>

<#if options?size gt 0>
  <#list options as key, value>
    <#assign podmanNetworkCreateCommand += " --opt ${key}=${value}">
  </#list>
</#if>

<#if additionalFlags?length gt 0> <#assign podmanNetworkCreateCommand += " ${additionalFlags}"> </#if>

<#assign podmanNetworkCreateCommand += " ${networkName}">

echo "Creating network ${networkName}"
${podmanNetworkCreateCommand}
IF %ERRORLEVEL% NEQ 0 exit /b 1
