#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xldpodman import getBaseURL
import requests
import json
import base64

registries = deployed.container['registries']
registry = None
authConf = None
credentials = None
XRegistryAuth={}
# Split image name into repository and tag
last_colon = deployed.image.rfind(':')
last_slash = deployed.image.rfind('/')
has_tag = last_colon != -1 and (last_slash == -1 or last_slash < last_colon)
if has_tag:
    image_repository = deployed.image[:last_colon]
    image_tag = deployed.image[last_colon+1:]
else:
    image_repository = deployed.image
    image_tag = 'latest'

for r in registries:
    if r.url:
        registry = r
        break

if registry:
    authConf = registry.username+':'+registry.password
    XRegistryAuth['username'] = registry.username
    XRegistryAuth['password'] = registry.password
    XRegistryAuth['serveraddress'] = registry.url
else:
    if len(registries)>0:
        print ('fallback: Using the first registry for auth username and pwd !')
        iterator = iter(registries)
        firstRegistry = next(iterator, None)
        authConf = firstRegistry.username+':'+firstRegistry.password
        XRegistryAuth['username'] = firstRegistry.username
        XRegistryAuth['password'] = firstRegistry.password
        XRegistryAuth['serveraddress'] = firstRegistry.url
    else:
        print('no auth can be used as no registry provided, check settings !!')

print "Pulling", image_repository, "image with tag", image_tag

url = getBaseURL(deployed.container)
url = url +"/libpod/images/pull"
headers={}
if(XRegistryAuth != {}):
    XRegistryAuth_json = json.dumps(XRegistryAuth)
    XRegistryAuth_base64 = XRegistryAuth_json.encode('utf-8')
    base64_bytes = base64.b64encode(XRegistryAuth_base64)
    headers['X-Registry-Auth']=base64_bytes

if authConf is not None:
    params={'reference': deployed.image , 'credentials': authConf}
else:
    params={'reference': deployed.image}
if(headers != {}):
    response = requests.post(url = url, params=params, headers=headers)
else:
    response = requests.post(url = url, params=params)
if not response.ok:
    responseLoad = response.json()
    print "Pulling Container Image Error with with cause : "+ responseLoad['cause']
    raise Exception("Pulling Container Image Error with with message : "+responseLoad['message'])
